<?php

namespace Database\Seeders;

use App\Models\Language;
use Illuminate\Database\Seeder;

class LanguageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $languages = [
            [
                'name' => 'English',
                'code' => 'en',
                'flag' => 'us', // ISO 3166-1 alpha-2 country code for flag-icons
                'is_rtl' => false,
                'status' => 'active',
            ],
            [
                'name' => 'Deutsch',
                'code' => 'de',
                'flag' => 'de',
                'is_rtl' => false,
                'status' => 'active',
            ],
            [
                'name' => '日本語',
                'code' => 'ja',
                'flag' => 'jp',
                'is_rtl' => false,
                'status' => 'active',
            ],
            [
                'name' => 'العربية',
                'code' => 'ar',
                'flag' => 'sa',
                'is_rtl' => true, // Arabic is RTL
                'status' => 'active',
            ],
            [
                'name' => 'Français',
                'code' => 'fr',
                'flag' => 'fr',
                'is_rtl' => false,
                'status' => 'active',
            ],
            [
                'name' => 'Bahasa Indonesia',
                'code' => 'id',
                'flag' => 'id',
                'is_rtl' => false,
                'status' => 'active',
            ],
            [
                'name' => '한국어',
                'code' => 'ko',
                'flag' => 'kr',
                'is_rtl' => false,
                'status' => 'active',
            ],
            [
                'name' => 'Türkçe',
                'code' => 'tr',
                'flag' => 'tr',
                'is_rtl' => false,
                'status' => 'active',
            ],
            [
                'name' => 'Tiếng Việt',
                'code' => 'vi',
                'flag' => 'vn',
                'is_rtl' => false,
                'status' => 'active',
            ],
            [
                'name' => '中文',
                'code' => 'zh',
                'flag' => 'cn',
                'is_rtl' => false,
                'status' => 'active',
            ],
        ];

        foreach ($languages as $lang) {
            $language = Language::updateOrCreate(
                ['code' => $lang['code']], // Find by code
                $lang // Update or create with these values
            );
            // Create translation files for each language (if they don't exist)
            $language->createTranslationFiles();
        }
    }
}
