<?php

return [
    // Page Titles
    'admin_overview' => 'Admin-Übersicht',
    'overview_title' => 'Übersicht',
    'users_title' => 'Benutzer',
    'subscriptions_title' => 'Abonnements',
    'transactions_title' => 'Transaktionen',
    'plans_title' => 'Tarife',
    'builders_title' => 'Builder',
    'plugins_title' => 'Plugins',
    'languages_title' => 'Sprachen',
    'cronjobs_title' => 'Cron-Jobs',
    'email_templates_title' => 'E-Mail-Vorlagen',
    'audit_logs_title' => 'Audit-Protokolle',
    'settings_title' => 'Einstellungen',

    // Page Subtitles
    'users_subtitle' => 'Plattformbenutzer und Konten verwalten',
    'subscriptions_subtitle' => 'Benutzerabonnements und Abrechnung überwachen',
    'transactions_subtitle' => 'Zahlungstransaktionen anzeigen und verwalten',
    'plans_subtitle' => 'Abonnement-Tarife und Preise konfigurieren',
    'builders_subtitle' => 'Builder für App-Kompilierung verwalten',
    'plugins_subtitle' => 'Installierte Plugins verwalten',
    'languages_subtitle' => 'Verfügbare Sprachen verwalten',
    'cronjobs_subtitle' => 'Geplante Aufgaben überwachen',
    'email_templates_subtitle' => 'E-Mail-Benachrichtigungen an Benutzer anpassen',
    'cronjobs_subtitle_full' => 'Geplante Aufgaben und Automatisierung überwachen',
    'settings_subtitle_full' => 'Systemweite Einstellungen und Präferenzen konfigurieren',
    'search_settings' => 'Einstellungen suchen...',
    'no_settings_found' => 'Keine Einstellungen gefunden für',
    'system_settings' => 'Systemeinstellungen',
    'clear_search' => 'Suche löschen',

    // Settings Sidebar Navigation
    'settings_section_general' => 'Allgemein',
    'settings_section_plans' => 'Tarife',
    'settings_section_auth' => 'Authentifizierung',
    'settings_section_email' => 'E-Mail',
    'settings_section_privacy' => 'Datenschutz',
    'settings_section_preview' => 'Vorschau',
    'settings_section_ai' => 'KI-Chat',
    'settings_category_platform' => 'Plattform',
    'settings_category_security' => 'Sicherheit',
    'settings_category_integrations' => 'Integrationen',
    'audit_logs_subtitle' => 'Benutzeraktionen und Systemereignisse für DSGVO-Compliance verfolgen',
    'no_audit_logs_found' => 'Keine Audit-Protokolle gefunden.',
    'search_audit_logs' => 'Nach Benutzer, Aktion, IP suchen...',
    'date_time' => 'Datum/Uhrzeit',
    'actor' => 'Akteur',
    'ip_address' => 'IP-Adresse',
    'details' => 'Details',
    'view_details' => 'Details anzeigen',
    'system' => 'System',
    'clear_filters' => 'Filter löschen',
    'to' => 'bis',
    'settings_subtitle' => 'Systemeinstellungen konfigurieren',

    // Users
    'add_user' => 'Benutzer hinzufügen',
    'edit_user' => 'Benutzer bearbeiten',
    'create_user' => 'Benutzer erstellen',
    'delete_user' => 'Benutzer löschen',
    'user_info' => 'Benutzerinfo',
    'user_details' => 'Benutzerdetails',
    'no_users_found' => 'Keine Benutzer gefunden.',
    'search_users' => 'Benutzer suchen...',
    'user_role' => 'Rolle',
    'user_plan' => 'Tarif',
    'user_joined' => 'Beigetreten',
    'email_verified' => 'E-Mail verifiziert',
    'mark_email_verified' => 'E-Mail als verifiziert markieren',
    'role_admin' => 'Administrator',
    'role_user' => 'Benutzer',
    'leave_blank_password' => 'Leer lassen, um aktuelles Passwort zu behalten',

    // Plans
    'add_plan' => 'Tarif hinzufügen',
    'edit_plan' => 'Tarif bearbeiten',
    'create_plan' => 'Tarif erstellen',
    'create_new_plan' => 'Neuen Tarif erstellen',
    'update_plan' => 'Tarif aktualisieren',
    'delete_plan' => 'Tarif löschen',
    'no_plans_found' => 'Keine Tarife gefunden.',
    'plan_features' => 'Funktionen',
    'plan_price' => 'Preis',
    'plan_interval' => 'Abrechnungsintervall',
    'monthly' => 'Monatlich',
    'yearly' => 'Jährlich',
    'default_plan' => 'Standard-Tarif',
    'mark_as_default' => 'Als Standard-Tarif markieren',
    'per_month' => '/Monat',
    'subscribers' => 'Abonnenten',
    'plan_name' => 'Tarifname',
    'plan_name_placeholder' => 'Pro',
    'basic_information' => 'Grundinformationen',
    'usage_limits' => 'Nutzungslimits',
    'monthly_build_credits' => 'Monatliche Build-Credits',
    'unlimited' => 'Unbegrenzt',
    'appetize_preview' => 'Appetize-Vorschau',
    'hosted_pages' => 'Gehostete Seiten',
    'ai_assistant' => 'KI-Assistent',
    'allow_own_api_keys' => 'Eigene API-Schlüssel erlauben',
    'permissions' => 'Berechtigungen',
    'custom_css_js_injection' => 'Benutzerdefinierte CSS/JS-Injektion',
    'api_access' => 'API-Zugang',
    'builder_access' => 'Builder-Zugang',
    'all_builders_allowed' => 'Alle Builder erlaubt',
    'select_builders' => 'Builder auswählen',
    'builders_selected' => ':count Builder ausgewählt|:count Builder ausgewählt',
    'allow_all_builders' => 'Alle Builder erlauben',
    'search_builders_placeholder' => 'Builder suchen...',
    'features_pricing_display' => 'Funktionen (Preisanzeige)',
    'feature_name' => 'Funktionsname',
    'included' => 'Enthalten',
    'not_included' => 'Nicht enthalten',
    'no_features_added' => 'Noch keine Funktionen hinzugefügt. Fügen Sie Funktionen hinzu, die auf der Preisseite angezeigt werden.',

    // Subscriptions
    'add_subscription' => 'Abonnement hinzufügen',
    'subscription_details' => 'Abonnementdetails',
    'no_subscriptions_found' => 'Keine Abonnements gefunden.',
    'search_subscriptions' => 'Abonnements suchen...',
    'renewal_date' => 'Verlängerungsdatum',
    'subscription_status' => 'Status',
    'change_plan' => 'Tarif wechseln',
    'cancel_subscription' => 'Abonnement kündigen',
    'next_billing' => 'Nächste Abrechnung',
    'no_plan' => 'Kein Tarif',
    'select_user' => 'Benutzer auswählen',
    'select_plan' => 'Tarif auswählen',
    'payment_method_placeholder' => 'Manuell, Banküberweisung usw.',

    // Transactions
    'transaction_details' => 'Transaktionsdetails',
    'no_transactions_found' => 'Keine Transaktionen gefunden.',
    'search_transactions' => 'Transaktionen suchen...',
    'transaction_id' => 'ID',
    'transaction_date' => 'Datum',
    'transaction_amount' => 'Betrag',
    'payment_method' => 'Zahlungsmethode',
    'payment_gateway' => 'das Zahlungsgateway',
    'transaction_status' => 'Status',
    'approve' => 'Genehmigen',
    'decline' => 'Ablehnen',
    'confirm_approval' => 'Genehmigung bestätigen',
    'confirm_decline' => 'Ablehnung bestätigen',
    'approve_payment' => 'Zahlung genehmigen',
    'decline_payment' => 'Zahlung ablehnen',
    'approve_bank_transfer_confirm' => 'Sind Sie sicher, dass Sie diese Banküberweisung genehmigen möchten? Dadurch wird das Abonnement des Benutzers aktiviert.',
    'decline_bank_transfer_confirm' => 'Sind Sie sicher, dass Sie diese Banküberweisung ablehnen möchten? Dadurch wird das Abonnement gekündigt und der Benutzer benachrichtigt.',

    // Builders
    'add_builder' => 'Builder hinzufügen',
    'edit_builder' => 'Builder bearbeiten',
    'create_builder' => 'Builder erstellen',
    'delete_builder' => 'Builder löschen',
    'no_builders_found' => 'Keine Builder gefunden.',
    'search_builders' => 'Builder suchen...',
    'builder_name' => 'Builder-Name',
    'builder_url' => 'URL',
    'builder_status' => 'Status',
    'builder_platform' => 'Plattform',
    'builder_platforms' => 'Plattformen',
    'builder_name_placeholder' => 'Produktions-Builder',
    'server_url_placeholder' => 'http://192.168.2.29',
    'server_key_placeholder' => 'Generierter Server-Schlüssel',
    'builder_queue' => 'Warteschlange',
    'current_builds' => 'Aktuelle Builds',
    'total_builds' => 'Gesamte Builds',
    'server_url' => 'Server-URL',
    'port' => 'Port',
    'server_key' => 'Server-Schlüssel',
    'server_key_help' => 'Wird zur Authentifizierung von API-Anfragen an diesen Builder verwendet',
    'generate' => 'Generieren',
    'max_queue' => 'Max. Warteschlange',
    'max_queue_help' => 'Maximale gleichzeitige Builds',
    'build_credit_cost' => 'Build-Credit-Kosten',
    'credit_cost_help' => 'Credits, die pro Build abgezogen werden',
    'supported_platforms' => 'Unterstützte Plattformen',
    'select_platforms' => 'Plattformen auswählen',
    'platforms_selected' => ':count Plattform ausgewählt|:count Plattformen ausgewählt',
    'platforms_help' => 'Wählen Sie eine oder mehrere Plattformen, die dieser Builder unterstützt',
    'no_platforms_available' => 'Keine Plattformen verfügbar',
    'no_builders_configured' => 'Noch keine Builder konfiguriert.',
    'default' => 'Standard',
    'locked' => 'Gesperrt',
    'from_purchase_code' => 'Vom Kaufcode',
    'purchase_code_not_set_warning' => 'Kaufcode nicht konfiguriert',
    'purchase_code_not_set_description' => 'Der Standard-Builder benötigt einen gültigen Kaufcode. Bitte konfigurieren Sie ihn unter Einstellungen > Allgemein.',
    'server_key_from_purchase_code_help' => 'Der Server-Schlüssel wird automatisch von Ihrem Kaufcode übernommen.',

    // Plugins
    'upload_plugin' => 'Plugin hochladen',
    'configure_plugin' => 'Konfigurieren',
    'delete_plugin' => 'Plugin löschen',
    'no_plugins_found' => 'Keine Plugins gefunden.',
    'plugin_name' => 'Name',
    'plugin_version' => 'Version',
    'plugin_type' => 'Typ',
    'plugin_status' => 'Status',

    // Languages
    'add_language' => 'Sprache hinzufügen',
    'add_new_language' => 'Neue Sprache hinzufügen',
    'edit_language' => 'Sprache bearbeiten',
    'create_language' => 'Sprache erstellen',
    'delete_language' => 'Sprache löschen',
    'no_languages_found' => 'Keine Sprachen gefunden.',
    'cannot_delete_default_language' => 'Die Standard- oder Hauptsprache kann nicht gelöscht werden.',
    'default_language_badge' => 'Standard',
    'language_name' => 'Sprachname',
    'language_code' => 'Sprachcode',
    'language_code_help' => '2-stelliger ISO 639-1 Code (z.B. en, es, fr)',
    'language_code_from_folder' => 'Aus verfügbaren Übersetzungsordnern auswählen',
    'language_flag' => 'Flagge',
    'language_flag_help' => 'Länderflagge-Emoji',
    'language_flag_auto' => 'Flagge wird automatisch basierend auf dem Sprachcode gesetzt',
    'language_flag_country_code_help' => '2-stelliger Ländercode (z.B. us, gb, es)',
    'language_name_placeholder' => 'Deutsch',
    'language_code_placeholder' => 'de',
    'language_flag_placeholder' => '🇩🇪',
    'language_status' => 'Status',
    'rtl_support' => 'Textrichtung',
    'rtl_enabled' => 'Rechts-nach-Links (RTL)',
    'rtl_description' => 'Aktivieren für Sprachen wie Arabisch, Hebräisch, Persisch und Urdu',
    'translation_files_created' => 'Übersetzungsdateien werden erstellt unter: lang/:code/',
    'translation_files_auto_created' => 'Stellen Sie sicher, dass Übersetzungsdateien in :path vorhanden sind, bevor Sie diese Sprache hinzufügen. Kopieren Sie den Ordner lang/en/, benennen Sie ihn in Ihren Sprachcode um und übersetzen Sie den Inhalt.',

    // Email Templates
    'edit_template' => 'Vorlage bearbeiten',
    'edit_email_template' => 'E-Mail-Vorlage bearbeiten',
    'reset_template' => 'Auf Standard zurücksetzen',
    'no_templates_found' => 'Keine Vorlagen gefunden.',
    'template_subject' => 'Betreff',
    'template_body' => 'Inhalt',
    'template_variables' => 'Verfügbare Variablen',
    'subject_line' => 'Betreffzeile',
    'email_subject_placeholder' => 'E-Mail-Betreff...',
    'email_body' => 'E-Mail-Inhalt',
    'click_to_insert' => 'Klicken zum Einfügen an Cursorposition',
    'no_variables_available' => 'Keine Variablen für diese Vorlage verfügbar.',
    'quick_tips' => 'Schnelltipps',
    'variables_replaced' => 'Variablen werden beim Versand durch echte Daten ersetzt',
    'toolbar_format_tip' => 'Verwenden Sie die Symbolleiste zum Formatieren von Text, Hinzufügen von Links und Erstellen von Listen',
    'link_tip' => 'Text markieren und auf den Link-Button klicken, um anklickbare Links hinzuzufügen',

    // Cronjobs
    'no_cronjobs_found' => 'Keine Cron-Jobs gefunden.',
    'no_cron_logs_found' => 'Keine Cron-Protokolle gefunden.',
    'search_logs' => 'Protokolle suchen...',
    'job_name' => 'Job-Name',
    'job' => 'Job',
    'last_run' => 'Letzter Lauf',
    'next_run' => 'Nächster Lauf',
    'run_duration' => 'Dauer',
    'started' => 'Gestartet',
    'duration' => 'Dauer',
    'triggered_by' => 'Ausgelöst von',
    'message' => 'Nachricht',
    'all_jobs' => 'Alle Jobs',
    'trigger_manually' => 'Manuell auslösen',
    'status_success' => 'Erfolgreich',
    'status_running' => 'Läuft',

    // Settings
    'general_settings' => 'Allgemeine Einstellungen',
    'email_settings' => 'E-Mail-Einstellungen',
    'social_login_settings' => 'Social Login',
    'appetize_settings' => 'Appetize-Einstellungen',
    'ai_settings' => 'KI-Einstellungen',
    'gdpr_settings' => 'DSGVO-Einstellungen',

    // General Settings Fields
    'site_name' => 'Seitenname',
    'site_description' => 'Seitenbeschreibung',
    'site_tagline' => 'Slogan',
    'logo' => 'Logo',
    'logo_dark' => 'Dunkelmodus-Logo',
    'favicon' => 'Favicon',
    'default_theme' => 'Standard-Theme',
    'landing_page_enabled' => 'Landing-Page aktivieren',
    'system_currency' => 'Systemwährung',
    'default_language' => 'Standardsprache',
    'default_language_description' => 'Standardsprache für neue Besucher und Benutzer ohne Präferenz',

    // Status Labels
    'status_active' => 'Aktiv',
    'status_inactive' => 'Inaktiv',
    'status_pending' => 'Ausstehend',
    'status_expired' => 'Abgelaufen',
    'status_cancelled' => 'Gekündigt',
    'status_completed' => 'Abgeschlossen',
    'status_failed' => 'Fehlgeschlagen',

    // Demo Mode
    'demo_mode_notice' => 'Einstellungen können im Demo-Modus nicht geändert werden.',
    'disabled_in_demo' => 'Im Demo-Modus deaktiviert',
    'hidden_in_demo' => 'Im Demo-Modus ausgeblendet',

    // Plugins
    'plugins_title_full' => 'Plugins',
    'plugins_subtitle_full' => 'Funktionalität mit benutzerdefinierten Plugins erweitern',
    'no_plugins_installed' => 'Keine Plugins installiert',
    'plugin_activate' => 'Aktivieren',
    'plugin_deactivate' => 'Deaktivieren',
    'plugin_uninstall' => 'Deinstallieren',
    'plugin_author' => 'von :author',

    // Languages
    'languages_title_full' => 'Sprachen',
    'languages_subtitle_full' => 'Sprachübersetzungen und Lokalisierung verwalten',

    // Cronjobs
    'cronjobs_title_full' => 'Cron-Jobs',
    'cronjobs_tab_jobs' => 'Geplante Jobs',
    'cronjobs_tab_logs' => 'Ausführungsprotokolle',
    'execute_job' => 'Ausführen',
    'executing_job' => 'Wird ausgeführt...',

    // Email Settings
    'email_config_title' => 'E-Mail-Konfiguration',
    'email_config_subtitle' => 'E-Mail-Einstellungen und SMTP-Server konfigurieren',
    'mail_driver' => 'E-Mail-Treiber',
    'php_mail' => 'PHP Mail',
    'smtp' => 'SMTP',
    'php_mail_description' => 'PHP Mail verwendet die integrierte E-Mail-Konfiguration Ihres Servers. Einfach, aber möglicherweise Zustellbarkeitsprobleme auf einigen Servern.',
    'php_mail_warning' => 'Hinweis: Einige Hosting-Anbieter deaktivieren PHPs mail()-Funktion. Wenn E-Mails nicht gesendet werden, wechseln Sie zu SMTP.',
    'smtp_config' => 'SMTP-Server-Konfiguration',
    'smtp_host' => 'SMTP-Host',
    'smtp_port' => 'SMTP-Port',
    'smtp_username' => 'SMTP-Benutzername',
    'smtp_password' => 'SMTP-Passwort',
    'smtp_encryption' => 'Verschlüsselung',
    'encryption_tls' => 'TLS',
    'encryption_ssl' => 'SSL',
    'encryption_none' => 'Keine',
    'admin_notifications' => 'Admin-Benachrichtigungen',
    'admin_email' => 'Admin-Benachrichtigungs-E-Mail',
    'admin_email_help' => 'E-Mail-Adresse für Admin-Benachrichtigungen. Falls leer, wird die E-Mail des angemeldeten Admins verwendet.',
    'notify_user_registered' => 'Neuer Benutzer registriert',
    'notify_subscription_created' => 'Neues Abonnement erstellt',
    'notify_subscription_cancelled' => 'Abonnement gekündigt',
    'notify_payment_received' => 'Zahlung erhalten',
    'notify_payment_failed' => 'Zahlung fehlgeschlagen',
    'notify_build_started' => 'Build gestartet',
    'notify_build_completed' => 'Build abgeschlossen',
    'notify_build_failed' => 'Build fehlgeschlagen',
    'test_email' => 'Test-E-Mail',
    'send_test_email' => 'Test-E-Mail senden',
    'sending' => 'Wird gesendet...',
    'mail_from_name' => 'Absendername',
    'mail_from_address' => 'Absenderadresse',
    'php_mail_info' => 'PHP Mail verwendet die integrierte E-Mail-Konfiguration Ihres Servers (sendmail/postfix). Keine zusätzliche Einrichtung erforderlich.',
    'php_mail_switch_warning' => 'Hinweis: Einige Hosting-Anbieter deaktivieren PHPs mail()-Funktion. Wenn E-Mails nicht gesendet werden, wechseln Sie zu SMTP.',
    'admin_notifications_subtitle' => 'Konfigurieren Sie, wohin Admin-Zahlungsbenachrichtigungen gesendet werden',
    'admin_email_description' => 'E-Mail-Adresse für Admin-Benachrichtigungen. Wird auch für Test-E-Mails verwendet.',
    'notification_events' => 'Benachrichtigungsereignisse',
    'notification_events_description' => 'Wählen Sie, welche Ereignisse Admin-Benachrichtigungen auslösen sollen',
    'event_subscription_activated' => 'Abonnement aktiviert',
    'event_payment_completed' => 'Zahlung abgeschlossen',
    'event_payment_failed' => 'Zahlung fehlgeschlagen',
    'event_subscription_cancelled' => 'Abonnement gekündigt',
    'event_subscription_expired' => 'Abonnement abgelaufen',
    'event_bank_transfer_pending' => 'Banküberweisung ausstehend',
    'event_user_registered' => 'Benutzer registriert',
    'event_build_completed' => 'Build abgeschlossen',
    'event_build_failed' => 'Build fehlgeschlagen',

    // Social Login Settings
    'auth_settings_title' => 'Authentifizierungseinstellungen',
    'auth_settings_subtitle' => 'Registrierung und Social-Login-Optionen konfigurieren',
    'enable_registration' => 'Registrierung aktivieren',
    'enable_registration_description' => 'Neuen Benutzern die Kontoregistrierung erlauben',
    'require_email_verification' => 'E-Mail-Verifizierung erforderlich',
    'require_email_verification_description' => 'Bei Deaktivierung werden neue Registrierungen automatisch verifiziert',
    'recaptcha_title' => 'reCAPTCHA v3',
    'recaptcha_description' => 'Authentifizierungsformulare vor Bots schützen',
    'recaptcha_site_key' => 'Site-Schlüssel',
    'recaptcha_site_key_placeholder' => 'Ihr reCAPTCHA v3 Site-Schlüssel',
    'recaptcha_secret_key' => 'Geheimer Schlüssel',
    'recaptcha_secret_key_placeholder' => 'Ihr reCAPTCHA v3 Geheimer Schlüssel',
    'leave_blank_keep_current' => 'Leer lassen, um aktuellen Wert zu behalten',
    'google_login' => 'Google',
    'facebook_login' => 'Facebook',
    'github_login' => 'GitHub',
    'client_id' => 'Client-ID',
    'client_id_placeholder' => 'Ihre :provider Client-ID',
    'client_secret' => 'Client-Secret',
    'client_secret_placeholder' => 'Ihr :provider Client-Secret',
    'app_id' => 'App-ID',
    'app_id_placeholder' => 'Ihre :provider App-ID',
    'app_secret' => 'App-Secret',
    'app_secret_placeholder' => 'Ihr :provider App-Secret',
    'callback_url' => 'Callback-URL',
    'oauth_help' => 'Erstellen Sie OAuth-Anmeldedaten in der :provider Developer Console. Verwenden Sie die obige Callback-URL.',
    'test_connection' => 'Verbindung testen',
    'testing' => 'Wird getestet...',
    'configure_oauth' => ':provider OAuth-Anmeldedaten konfigurieren',
    'add_url_to_console' => 'Fügen Sie diese URL zu Ihrer :provider hinzu',
    'leave_blank_keep_current' => 'Leer lassen, um aktuellen Wert zu behalten',
    'your_provider_key' => 'Ihr :provider :type',
    'recaptcha_help' => 'Holen Sie Ihre Schlüssel von der :link. Stellen Sie sicher, dass Sie reCAPTCHA v3 auswählen.',
    'recaptcha_console' => 'Google reCAPTCHA Admin-Konsole',
    'get_api_key_from' => 'Holen Sie Ihren API-Schlüssel von :link',

    // General Settings
    'general_settings_title' => 'Allgemeine Einstellungen',
    'general_settings_subtitle' => 'Seiteninformationen und Branding aktualisieren',
    'site_name_label' => 'Seitenname',
    'site_description_label' => 'Seitenbeschreibung',
    'site_description_placeholder' => 'Verwendet für Meta-Beschreibung und SEO',
    'site_tagline_label' => 'Slogan',
    'site_tagline_placeholder' => 'Kurzer Slogan unter dem Logo',
    'site_tagline_help' => 'Wird unter dem Logo in Seitenleiste und Anmeldeseiten angezeigt',
    'purchase_code_label' => 'Kaufcode',
    'purchase_code_help' => 'Ihre Lizenz oder Ihr Kaufcode für diese Installation (optional)',
    'logo_light' => 'Logo (Hellmodus)',
    'logo_dark_label' => 'Logo (Dunkelmodus)',
    'delete_logo' => 'Logo löschen',
    'delete_dark_logo' => 'Dunkles Logo löschen',
    'delete_favicon' => 'Favicon löschen',
    'logo_help' => 'Empfohlen: 200x50px (horizontal) oder 50x50px (quadratisch). PNG, JPG, SVG mit transparentem Hintergrund. Max 2MB.',
    'favicon_label' => 'Favicon',
    'favicon_help' => 'Empfohlen: 32x32px oder 16x16px. PNG, ICO oder SVG. Max 1MB.',
    'default_theme_label' => 'Standard-Farbschema',
    'theme_system' => 'System (Gerätepräferenz des Benutzers folgen)',
    'theme_light' => 'Hell',
    'theme_dark' => 'Dunkel',
    'theme_help' => 'Standard-Theme für neue Besucher. Benutzer können dies in ihren Einstellungen ändern.',
    'currency_label' => 'Systemwährung',
    'currency_help' => 'Währung für alle Preise und Zahlungen. Dies bestimmt, welche Zahlungsgateways verfügbar sind.',
    'landing_page_toggle' => 'Öffentliche Landing-Page aktivieren',
    'landing_page_help' => 'Bei Deaktivierung werden Besucher, die die Stamm-URL (/) aufrufen, zur Anmeldeseite weitergeleitet',

    // Plan Configuration Settings
    'plan_config_title' => 'Tarifkonfiguration',
    'plan_config_subtitle' => 'Standard-Tarifeinstellungen für neue Benutzer konfigurieren',
    'default_plan_label' => 'Standard-Tarif',
    'default_plan_none' => 'Keiner (Abonnement erforderlich)',
    'default_plan_help' => 'Tarif, der neuen Benutzern bei der Registrierung zugewiesen wird. Wenn kein Tarif ausgewählt ist, müssen Benutzer abonnieren, um auf Funktionen zuzugreifen.',

    // AI Settings
    'ai_settings_title' => 'KI-Chat-Assistent',
    'ai_settings_subtitle' => 'KI-gestützten App-Erstellungsassistenten konfigurieren',
    'enable_ai' => 'KI-Chat-Assistent aktivieren',
    'enable_ai_description' => 'Benutzern erlauben, Apps per KI-Konversation zu erstellen und zu konfigurieren',
    'enable_streaming' => 'Streaming-Antworten aktivieren',
    'enable_streaming_description' => 'KI-Antworten Wort für Wort streamen für ein interaktiveres Erlebnis',
    'streaming_warning' => 'Funktioniert möglicherweise nicht in allen Shared-Hosting-Umgebungen',
    'ai_provider' => 'KI-Anbieter',
    'ai_provider_help' => 'Wählen Sie zwischen OpenAI (GPT-4.1) oder Anthropic (Claude)',
    'api_key' => 'API-Schlüssel',
    'enter_api_key' => 'Geben Sie Ihren API-Schlüssel ein',
    'openai_console' => 'OpenAI-Konsole',
    'anthropic_console' => 'Anthropic-Konsole',
    'api_key_help' => 'Holen Sie Ihren API-Schlüssel von der :provider',
    'advanced_settings' => 'Erweiterte Einstellungen',
    'ai_model' => 'KI-Modell',
    'ai_model_help' => 'Wählen Sie das KI-Modell für Chat-Antworten',
    'temperature' => 'Temperatur',
    'temperature_help' => 'Kontrolliert Zufälligkeit. Niedriger = fokussierter, Höher = kreativer',
    'max_tokens' => 'Max. Antwort-Token',
    'max_tokens_help' => 'Maximale Token pro KI-Antwort. Höhere Werte = längere Antworten, aber mehr Kosten',
    'auto_summarization' => 'Auto-Zusammenfassung',
    'enable_summarization' => 'Auto-Zusammenfassung aktivieren',
    'summarization_help' => 'Ältere Nachrichten automatisch zusammenfassen, um Token-Verbrauch in langen Konversationen zu reduzieren',
    'summarization_threshold' => 'Zusammenfassungsschwelle',
    'summarization_threshold_help' => 'Anzahl der Nachrichten, bevor Auto-Zusammenfassung ausgelöst wird',
    'summarization_keep_recent' => 'Letzte Nachrichten behalten',
    'summarization_keep_recent_help' => 'Anzahl der letzten Nachrichten, die behalten werden sollen',
    'summarization_max_length' => 'Max. Zusammenfassungslänge',
    'summarization_max_length_help' => 'Maximale Zeichen für Zusammenfassung',
    'chat_widget' => 'Chat-Widget',
    'widget_position' => 'Widget-Position',
    'position_bottom_right' => 'Unten rechts',
    'position_bottom_left' => 'Unten links',
    'position_top_right' => 'Oben rechts',
    'position_top_left' => 'Oben links',
    'position_help' => 'Position des KI-Chat-Widgets auf der App-Editor-Seite',

    // GDPR Settings
    'gdpr_settings_title' => 'DSGVO-Einstellungen',
    'gdpr_settings_subtitle' => 'DSGVO-Compliance und Datenschutzeinstellungen konfigurieren',
    'enable_cookie_consent' => 'Cookie-Consent-Banner aktivieren',
    'enable_data_export' => 'Datenexport aktivieren',
    'enable_account_deletion' => 'Kontolöschung aktivieren',
    'deletion_grace_period' => 'Kontolöschung-Karenzzeit (Tage)',
    'audit_log_retention' => 'Audit-Log-Aufbewahrung (Tage)',

    // Appetize Settings
    'appetize_settings_title' => 'Appetize-Einstellungen',
    'appetize_settings_subtitle' => 'Appetize.io für Live-App-Vorschauen konfigurieren',
    'appetize_api_token' => 'Appetize API-Token',
    'appetize_api_token_help' => 'Holen Sie Ihren API-Token aus Ihrem Appetize.io-Dashboard',

    // Delete/Action Modal Messages
    'delete_user_confirm' => 'Sind Sie sicher, dass Sie löschen möchten',
    'delete_builder_confirm' => 'Sind Sie sicher, dass Sie löschen möchten',
    'delete_plan_confirm' => 'Sind Sie sicher, dass Sie den',
    'delete_plan_confirm_suffix' => 'Tarif löschen möchten?',
    'delete_language_confirm' => 'Sind Sie sicher, dass Sie löschen möchten',
    'delete_language_note' => 'Diese Aktion kann nicht rückgängig gemacht werden. Übersetzungsdateien werden zur Datensicherheit aufbewahrt.',
    'uninstall_plugin' => 'Plugin deinstallieren',
    'uninstall_plugin_confirm' => 'Sind Sie sicher, dass Sie deinstallieren möchten',
    'cancel_subscription_confirm' => 'Sind Sie sicher, dass Sie das Abonnement kündigen möchten für',
    'reset_email_template' => 'E-Mail-Vorlage zurücksetzen',
    'reset_template_confirm' => 'Sind Sie sicher, dass Sie zurücksetzen möchten',
    'reset_template_confirm_suffix' => 'auf den Standardinhalt?',
    'reset_template_warning' => 'Alle Anpassungen gehen verloren.',
    'disabled_in_demo' => 'Im Demo-Modus deaktiviert',

    // Plugin Upload Modal
    'plugin_file' => 'Plugin-Datei',
    'plugin_file_help' => 'ZIP-Datei (MAX. 10MB)',
    'installing_plugin' => 'Plugin wird installiert...',
    'installing' => 'Wird installiert...',

    // Plugin Config Modal
    'configure_plugin_title' => ':name konfigurieren',
    'no_config_required' => 'Keine Konfiguration erforderlich',
    'no_config_required_desc' => 'Dieses Plugin erfordert keine Konfiguration.',

    // Appetize Settings Extended
    'appetize_integration_title' => 'Appetize.io-Integration',
    'appetize_integration_subtitle' => 'Live-App-Vorschau-Funktionalität konfigurieren',
    'enable_appetize_integration' => 'Appetize.io-Integration aktivieren',
    'enable_appetize_description' => 'Benutzern mit Pro/Enterprise-Tarifen erlauben, Apps im Browser zu previewen',
    'appetize_api_token_placeholder' => 'Geben Sie Ihr Appetize.io API-Token ein',
    'appetize_api_token_link' => 'Holen Sie Ihr API-Token von',
    'auto_upload_builds' => 'Builds automatisch zu Appetize hochladen',
    'auto_upload_description' => 'Erfolgreiche Builds automatisch für sofortige Vorschau hochladen',
    'preview_retention_days' => 'Vorschau-Aufbewahrung (Tage)',
    'preview_retention_help' => 'Alte Vorschauen nach dieser Anzahl von Tagen löschen, um Kosten zu sparen (1-30 Tage)',
    'session_timeout_seconds' => 'Sitzungs-Timeout (Sekunden)',
    'session_timeout_help' => 'Inaktivitäts-Timeout vor Sitzungsende',
    'seconds_30' => '30 Sekunden',
    'minute_1' => '1 Minute',
    'minutes_2' => '2 Minuten',
    'minutes_3' => '3 Minuten',
    'minutes_5' => '5 Minuten',
    'minutes_10' => '10 Minuten',

    // GDPR Settings Extended
    'gdpr_privacy_settings_title' => 'DSGVO- & Datenschutzeinstellungen',
    'gdpr_privacy_settings_subtitle' => 'Datenschutz und Privacy-Compliance konfigurieren',
    'feature_toggles' => 'Funktions-Schalter',
    'cookie_consent_banner' => 'Cookie-Consent-Banner',
    'cookie_consent_description' => 'Cookie-Consent-Banner für neue Besucher anzeigen',
    'user_data_export' => 'Benutzerdaten-Export',
    'user_data_export_description' => 'Benutzern erlauben, eine Kopie ihrer Daten anzufordern',
    'user_account_deletion' => 'Benutzer-Kontolöschung',
    'user_account_deletion_description' => 'Benutzern erlauben, Kontolöschung anzufordern',
    'policy_versions' => 'Richtlinien-Versionen',
    'policy_versions_help' => 'Das Aktualisieren der Richtlinienversionen löst eine erneute Zustimmung für Benutzer aus.',
    'privacy_policy' => 'Datenschutzerklärung',
    'terms_of_service' => 'Nutzungsbedingungen',
    'cookie_policy' => 'Cookie-Richtlinie',
    'data_retention_periods' => 'Datenaufbewahrungsfristen (Tage)',
    'retention_transactions' => 'Transaktionen',
    'retention_transactions_help' => 'Min. 365 Tage (gesetzliche Anforderung)',
    'retention_inactive_accounts' => 'Inaktive Konten',
    'retention_expired_builds' => 'Abgelaufene Builds',
    'retention_audit_logs' => 'Audit-Protokolle',
    'retention_data_exports' => 'Datenexporte',
    'grace_periods_rate_limits' => 'Karenzzeiten & Rate-Limits',
    'account_deletion_grace_period' => 'Kontolöschung-Karenzzeit (Tage)',
    'account_deletion_grace_help' => 'Zeit, bevor das Konto endgültig gelöscht wird',
    'data_export_rate_limit' => 'Datenexport-Rate-Limit (Stunden)',
    'data_export_rate_limit_help' => 'Mindestzeit zwischen Exportanfragen',

    // App/Plan Settings
    'plan_configuration' => 'Tarifkonfiguration',
    'plan_configuration_subtitle' => 'Standard-Tarifeinstellungen für neue Benutzer konfigurieren',
    'default_plan_option_none' => 'Keiner (Abonnement erforderlich)',
    'default_plan_description' => 'Tarif, der neuen Benutzern zugewiesen wird. Wählen Sie "Keiner", um ein Abonnement vor der Nutzung zu erfordern.',

    // Overview Stats
    'overview_subtitle' => 'Systemweite Statistiken und Administrationsmetriken',
    'date_range_today' => 'Heute',
    'date_range_week' => 'Woche',
    'date_range_month' => 'Monat',
    'date_range_year' => 'Jahr',
    'date_range_all' => 'Gesamt',
    'auto_refresh' => 'Auto-Aktualisierung',
    'total_system_users' => 'Gesamte Systembenutzer',
    'active_subscriptions' => 'Aktive Abonnements',
    'revenue_label' => ':period Umsatz',
    'total_apps' => 'Gesamte Apps',
    'vs_last_month' => 'vs. letzter Monat',
    'total_builds_stat' => 'Gesamte Builds',
    'completed_today' => 'Heute abgeschlossen',
    'build_success_rate' => 'Build-Erfolgsrate',
    'pending_queue' => 'Ausstehende Warteschlange',
    'total_transactions' => 'Gesamte Transaktionen',
    'active_plans' => 'Aktive Tarife',
    'active_builders' => 'Aktive Builder',
    'revenue_trends' => 'Umsatztrends (12 Monate)',
    'build_activity' => 'Build-Aktivität (Letzte 30 Tage)',
    'revenue_by_gateway' => 'Umsatz nach Zahlungsgateway',
    'no_revenue_data' => 'Noch keine Umsatzdaten verfügbar',
    'total_revenue' => 'Gesamtumsatz',
    'platform_distribution' => 'Plattformverteilung',
    'no_apps_created' => 'Noch keine Apps erstellt',
    'pending_payments' => 'Ausstehende Zahlungen',
    'active_users_7d' => 'Aktive Benutzer (7T)',
    'notifications_today' => 'Benachrichtigungen (Heute)',
    'build_performance_by_platform' => 'Build-Leistung nach Plattform',
    'platform' => 'Plattform',
    'completed' => 'Abgeschlossen',
    'failed' => 'Fehlgeschlagen',
    'success_rate' => 'Erfolgsrate',
    'avg_duration' => 'Durchschn. Dauer',
    'revenue_label_short' => 'Umsatz',
    'builds_label' => 'Builds',
    'recent_user_registrations' => 'Letzte Benutzerregistrierungen',
    'no_users_yet' => 'Noch keine Benutzer',
    'recent_builds' => 'Letzte Builds',
    'no_builds_yet' => 'Noch keine Builds',
    'recent_transactions' => 'Letzte Transaktionen',
    'no_transactions_yet' => 'Noch keine Transaktionen',

    // Cronjobs Manager
    'cronjobs_tab_scheduled' => 'Jobs',
    'cronjobs_tab_execution_logs' => 'Ausführungsprotokolle',

    // Payment Gateway Configuration
    'payment_gateways' => [
        // Common
        'api_credentials' => 'API-Anmeldedaten',
        'webhook_configuration' => 'Webhook-Konfiguration',
        'webhook_url' => 'Webhook-URL',
        'copy' => 'Kopieren',
        'copied' => 'Kopiert!',
        'copy_failed' => 'Kopieren fehlgeschlagen. Bitte URL manuell markieren und kopieren.',
        'required_webhook_events' => 'Erforderliche Webhook-Ereignisse',
        'features' => 'Funktionen',
        'supported_features' => 'Unterstützte Funktionen',
        'secret_key' => 'Geheimer Schlüssel',
        'webhook_secret' => 'Webhook-Secret',
        'webhook_signing_secret' => 'Webhook-Signatur-Secret',
        'optional' => 'Optional',

        // SSL Warning
        'ssl_warning' => 'Warnung:',
        'ssl_warning_stripe' => 'Ihre Seite verwendet kein HTTPS. Stripe erfordert HTTPS für Webhooks und Produktivbetrieb.',
        'ssl_warning_paypal' => 'Ihre Seite verwendet kein HTTPS. PayPal-Webhooks erfordern eine sichere HTTPS-Verbindung. Bitte aktivieren Sie SSL/TLS vor dem Live-Betrieb.',
        'ssl_warning_paystack' => 'Ihre Seite verwendet kein HTTPS. Paystack-Webhooks erfordern eine sichere HTTPS-Verbindung. Bitte aktivieren Sie SSL/TLS vor dem Live-Betrieb.',

        // Stripe
        'stripe' => [
            'get_started' => 'Mit Stripe starten',
            'get_api_keys' => 'Holen Sie Ihre API-Schlüssel von',
            'dashboard_link' => 'Stripe Dashboard → Entwickler → API-Schlüssel',
            'secret_key_placeholder' => 'sk_live_...',
            'secret_key_help' => 'Verwenden Sie Test-Schlüssel (sk_test_) zum Testen, Live-Schlüssel (sk_live_) für Produktion',
            'webhook_url_help' => 'Fügen Sie diese URL hinzu unter Stripe Dashboard → Entwickler → Webhooks',
            'webhook_secret_placeholder' => 'whsec_...',
            'webhook_secret_help' => 'Erhalten Sie dies nach dem Erstellen des Webhook-Endpunkts im Stripe Dashboard',
            'events_help' => 'Wählen Sie diese Ereignisse beim Erstellen Ihres Webhook-Endpunkts:',
            'feature_currencies' => 'Über 135 Währungen weltweit unterstützt',
            'feature_intervals' => 'Alle Abrechnungsintervalle unterstützt',
            'feature_renewal' => 'Automatische Abonnementverlängerung',
            'feature_customer_management' => 'Kundenverwaltung',
            'feature_signature_verification' => 'Webhook-Signaturverifizierung',
            'feature_refund' => 'Rückerstattungsabwicklung',
            'feature_sca' => 'SCA-konform (Strong Customer Authentication)',
        ],

        // PayPal
        'paypal' => [
            'client_id' => 'Client-ID',
            'client_id_help' => 'Holen Sie dies vom PayPal Developer Dashboard',
            'client_secret' => 'Client-Secret',
            'client_secret_help' => 'Halten Sie dies geheim und teilen Sie es niemals öffentlich',
            'sandbox_mode' => 'Sandbox-Modus',
            'sandbox_mode_help' => 'Aktivieren Sie zum Testen mit PayPal Sandbox. Deaktivieren Sie für Live-Transaktionen.',
            'webhook_url_help' => 'Fügen Sie diese URL zu Ihren PayPal-Webhook-Einstellungen hinzu',
            'webhook_id' => 'Webhook-ID',
            'webhook_id_help' => 'Webhook-ID vom PayPal Dashboard für Signaturverifizierung (erforderlich für Sicherheit)',
            'events_help' => 'Stellen Sie sicher, dass diese Ereignisse in Ihrer PayPal-Webhook-Konfiguration aktiviert sind:',
        ],

        // Razorpay
        'razorpay' => [
            'get_started' => 'Mit Razorpay starten',
            'get_api_keys' => 'Holen Sie Ihre API-Schlüssel von',
            'dashboard_link' => 'Razorpay Dashboard → Einstellungen → API-Schlüssel',
            'key_id' => 'Schlüssel-ID',
            'key_id_placeholder' => 'rzp_live_...',
            'key_id_help' => 'Verwenden Sie Test-Schlüssel (rzp_test_) zum Testen, Live-Schlüssel (rzp_live_) für Produktion',
            'key_secret' => 'Schlüssel-Secret',
            'key_secret_help' => 'Halten Sie dies geheim und teilen Sie es niemals öffentlich',
            'webhook_url_help' => 'Fügen Sie diese URL hinzu unter Razorpay Dashboard → Einstellungen → Webhooks',
            'webhook_secret_placeholder' => 'Webhook-Secret eingeben',
            'webhook_secret_help' => 'Erhalten Sie dies vom Razorpay Dashboard nach dem Erstellen des Webhooks',
            'events_help' => 'Aktivieren Sie diese Ereignisse unter Razorpay Dashboard → Einstellungen → Webhooks:',
            'feature_currencies' => 'Über 100 Währungen unterstützt',
            'feature_intervals' => 'Alle Abrechnungsintervalle (täglich, wöchentlich, monatlich, jährlich)',
            'feature_payment_methods' => 'UPI, Karten, NetBanking, Wallets, EMI',
            'feature_renewal' => 'Automatische Abonnementverlängerung',
            'feature_signature_verification' => 'Webhook-Signaturverifizierung',
            'feature_refund' => 'Rückerstattungsabwicklung',
            'feature_decimal' => 'Drei-Dezimal-Währungsunterstützung (KWD, BHD usw.)',
        ],

        // Paystack
        'paystack' => [
            'get_started' => 'Mit Paystack starten',
            'get_api_keys' => 'Holen Sie Ihre API-Schlüssel von',
            'dashboard_link' => 'Paystack Dashboard → Einstellungen → API-Schlüssel & Webhooks',
            'secret_key_help' => 'Holen Sie dies vom Paystack Dashboard (verwenden Sie Test-Schlüssel zum Testen, Live-Schlüssel für Produktion)',
            'webhook_url_help' => 'Fügen Sie diese URL zu Ihren Paystack-Webhook-Einstellungen hinzu',
            'webhook_secret_help' => 'Optional: Für Webhook-Signaturverifizierung (empfohlen für Produktion)',
            'webhook_secret_placeholder' => 'Leer lassen, um Signaturverifizierung zu überspringen',
            'events_help' => 'Aktivieren Sie diese Ereignisse unter Paystack Dashboard → Einstellungen → API-Schlüssel & Webhooks:',
            'feature_currencies' => 'Währungen: NGN, USD, GHS, ZAR, KES',
            'feature_intervals' => 'Intervalle: Täglich, Wöchentlich, Monatlich (1, 3, 6 Monate), Jährlich',
            'feature_renewal' => 'Automatische Abonnementverlängerung',
            'feature_signature_verification' => 'Webhook-Signaturverifizierung',
            'feature_interval_limitation' => 'Eingeschränkte Intervallunterstützung (siehe Dokumentation)',
        ],

        // Crypto.com
        'cryptocom' => [
            'get_started' => 'Mit Crypto.com Pay starten',
            'get_api_keys' => 'Holen Sie Ihre API-Anmeldedaten von',
            'dashboard_link' => 'Crypto.com Pay Dashboard',
            'monthly_only_title' => 'Nur monatliche Intervalle',
            'monthly_only_description' => 'Crypto.com Pay unterstützt derzeit nur monatliche Abrechnungsintervalle. Tägliche, wöchentliche und jährliche Abonnements werden nicht unterstützt.',
            'secret_key_placeholder' => 'Geben Sie Ihren Crypto.com Pay Geheimschlüssel ein',
            'secret_key_help' => 'Holen Sie dies vom Crypto.com Pay Dashboard',
            'webhook_url_help' => 'Fügen Sie diese URL zu Ihren Crypto.com Pay Webhook-Einstellungen hinzu',
            'webhook_secret_placeholder' => 'Webhook-Signatur-Secret eingeben',
            'webhook_secret_help' => 'Erforderlich für Webhook-Signaturverifizierung',
            'events_help' => 'Aktivieren Sie diese Ereignisse im Crypto.com Pay Dashboard:',
            'feature_crypto_fiat' => 'Kryptowährungen und Fiat-Zahlungen akzeptieren',
            'feature_currencies' => 'Über 30 unterstützte Währungen',
            'feature_renewal' => 'Automatische Abonnementverlängerung',
            'feature_signature_verification' => 'HMAC SHA-256 Webhook-Signaturverifizierung',
            'feature_monthly_only' => 'Nur monatliche Intervalle (täglich/wöchentlich/jährlich nicht unterstützt)',
        ],

        // Bank Transfer
        'bank_transfer' => [
            'manual_approval_title' => 'Manuelle Genehmigung erforderlich',
            'manual_approval_description' => 'Banküberweisung-Zahlungen erfordern manuelle Überprüfung. Benutzer sehen die untenstehenden Anweisungen nach der Zahlungsinitiierung. Administratoren müssen Zahlungen genehmigen oder ablehnen unter',
            'transactions_link' => 'Transaktionen',
            'instructions_title' => 'Banküberweisung-Anweisungen',
            'instructions_label' => 'Anweisungen für Benutzer',
            'instructions_placeholder' => "Geben Sie hier Ihre Bankverbindung und Überweisungsanweisungen ein...\n\nBeispiel:\n\nBankname: ABC Bank\nKontoinhaber: Ihr Firmenname\nKontonummer: 123456789\nBIC/SWIFT: ABCDEFGH\nVerwendungszweck: [Benutzer sieht seine Abonnement-ID]\n\nBitte geben Sie Ihre Abonnement-ID im Verwendungszweck an und senden Sie einen Zahlungsnachweis an buchhaltung@ihrefirma.de",
            'instructions_help' => 'Diese Anweisungen werden Benutzern angezeigt, nachdem sie einen Tarif ausgewählt haben. Geben Sie Bankverbindung, Verwendungszweck-Format und Verifizierungsschritte an.',
            'workflow_title' => 'So funktionieren Banküberweisung-Zahlungen:',
            'workflow_step_1' => 'Benutzer wählt einen Tarif und wählt Banküberweisung als Zahlungsmethode',
            'workflow_step_2' => 'Ein ausstehendes Abonnement und eine Transaktion werden erstellt',
            'workflow_step_3' => 'Benutzer sieht die oben konfigurierten Anweisungen',
            'workflow_step_4' => 'Benutzer führt die Banküberweisung manuell durch',
            'workflow_step_5' => 'Administrator erhält Benachrichtigung über ausstehende Zahlung',
            'workflow_step_6' => 'Administrator genehmigt Zahlung → Abonnement wird aktiviert und Credits aufgefüllt',
            'workflow_step_7' => 'Administrator lehnt Zahlung ab → Abonnement und Transaktion werden entfernt',
            'feature_currencies' => 'Alle Währungen unterstützt',
            'feature_intervals' => 'Alle Abrechnungsintervalle unterstützt (täglich, wöchentlich, monatlich, jährlich)',
            'feature_simple_setup' => 'Einfache Einrichtung - keine API-Anmeldedaten erforderlich',
            'feature_manual_verification' => 'Manuelle Verifizierung für Sicherheit',
            'feature_no_fees' => 'Keine Transaktionsgebühren oder Drittanbieter-Abhängigkeit',
            'feature_admin_approval' => 'Erfordert Admin-Genehmigung für jede Zahlung',
            'feature_no_renewal' => 'Keine automatische Abonnementverlängerung',
        ],
    ],

    // Plan Features (dynamic)
    'feature_unlimited_build_credits' => 'Unbegrenzte Build-Credits',
    'feature_build_credits' => ':count Build-Credits',
    'feature_all_builders' => 'Zugang zu allen aktiven Buildern',
    'feature_builder_access' => 'Builder-Zugang',
    'feature_single_builder' => 'Zugang zu einem Builder',
    'feature_multiple_builders' => 'Zugang zu :count Buildern',
    'feature_custom_code' => 'Benutzerdefinierte CSS/JS-Injektion',
    'feature_api_access' => 'API-Zugang',
    'feature_unlimited_hosted_pages' => 'Unbegrenzte gehostete Seiten',
    'feature_hosted_pages' => ':count gehostete Seiten pro App',
    'feature_hosted_pages_disabled' => 'Gehostete Seiten',
    'feature_unlimited_ai_chat' => 'Unbegrenzter KI-Chat',
    'feature_ai_tokens' => ':count KI-Token/Monat',
    'feature_own_ai_key' => 'Eigenen KI-API-Schlüssel verwenden',
    'feature_ai_chat' => 'KI-Chat-Assistent',

    // Impersonation
    'impersonate' => 'Imitieren',
    'impersonate_user' => 'Benutzer imitieren',
    'impersonation_started' => 'Sie imitieren jetzt :name',
    'impersonation_stopped' => 'Imitation beendet. Willkommen zurück!',
    'impersonating_as' => 'Ansicht als :name',
    'exit_impersonation' => 'Beenden',
    'return_to_admin' => 'Zurück zum Admin',
    'not_impersonating' => 'Sie imitieren derzeit keinen Benutzer.',
    'admin_blocked_during_impersonation' => 'Der Admin-Bereich ist während der Imitation gesperrt. Beenden Sie zuerst die Imitation.',
    'impersonation_disabled_demo' => 'Imitation ist im Demo-Modus deaktiviert.',
    'only_admins_can_impersonate' => 'Nur Administratoren können Benutzer imitieren.',
];
