<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Platform Plugin Translation Strings
    |--------------------------------------------------------------------------
    |
    | The following language lines are used by the platform plugin blade
    | templates for settings and configuration pages.
    |
    */

    // General Settings
    'general' => [
        'basic_information' => 'Grundinformationen',
        'basic_information_description' => 'Wesentliche Details über Ihre App',
        'app_name' => 'App-Name',
        'app_name_placeholder' => 'Meine tolle App',
        'app_name_help' => 'Wird auf dem Startbildschirm des Geräts angezeigt',
        'website_url' => 'Website-URL',
        'website_url_placeholder' => 'https://beispiel.de',
        'website_url_help' => 'Vollständige URL Ihrer Website oder Web-App',
        'configuration' => 'Konfiguration',
        'configuration_description' => 'Technische Einstellungen und Bezeichner',
        'app_id' => 'APP-ID',
        'app_id_tooltip' => 'Eindeutiger Paketbezeichner, der von App Stores verwendet wird',
        'app_id_placeholder' => 'com.beispiel.app',
        'app_id_help' => 'App-ID kann nach der Erstellung nicht geändert werden',
        'copy' => 'Kopieren',
        'copied' => 'Kopiert!',
        'screen_orientation' => 'Bildschirmausrichtung',
        'screen_orientation_help' => 'Steuert, wie Ihre App auf dem Gerät rotiert',
        'orientation_system' => 'System',
        'orientation_portrait' => 'Hochformat',
        'orientation_landscape' => 'Querformat',
        'app_language' => 'App-Sprache (ISO-Code)',
        'app_language_help' => 'Primäre Sprache für Ihre App-Inhalte',
    ],

    // Design Settings
    'design' => [
        'layout_template' => 'Layout-Vorlage',
        'layout_template_description' => 'Wählen Sie die Navigationsstruktur für Ihre App',
        'layout_app_bar_drawer' => 'App-Bar + Drawer',
        'layout_app_bar_tabs' => 'App-Bar + Navigations-Tabs',
        'layout_app_bar' => 'App-Bar',
        'layout_blank' => 'Leer',
        'progress_indicator' => 'Ladeindikator',
        'progress_indicator_help' => 'Stil des Ladeindikators beim Laden von Seiten',
        'progress_disable' => 'Deaktivieren',
        'progress_linear' => 'Linear',
        'progress_circular' => 'Kreisförmig',
        'progress_indicator_color' => 'Ladeindikator-Farbe',
        'progress_indicator_color_help' => 'Farbe des Ladefortschrittsindikators',
        'show_app_bar_title' => 'Aktuellen Webseitentitel in der App-Bar anzeigen',
        'show_app_bar_title_help' => 'Titel der aktuellen Seite in der oberen Leiste anzeigen',
        'nav_tab_icon_colors' => 'Navigations-Tab Icon-Farben',
        'nav_tab_icon_colors_help' => 'Farbe der inaktiven Tab-Icons im Hell- und Dunkelmodus',
        'active_tab_colors' => 'Aktive Tab-Farben',
        'active_tab_colors_help' => 'Farbe des ausgewählten Tabs im Hell- und Dunkelmodus',
        'light_mode' => 'Hellmodus',
        'dark_mode' => 'Dunkelmodus',
        'theme_colors' => 'Theme-Farben',
        'theme_colors_description' => 'Primärfarben, die das Erscheinungsbild Ihrer App definieren',
        'theme_color' => 'Theme-Farbe',
        'theme_color_help' => 'Hauptfarbe, die in Ihrer App verwendet wird',
        'enable_dynamic_colors' => 'Material You Dynamic Colors aktivieren (Android 12+)',
        'enable_dynamic_colors_help' => 'Bei Aktivierung passt Ihre App die Farben an das Hintergrundbild des Benutzers auf Android 12+ Geräten an. Dies überschreibt die obige Theme-Farbe.',
        'text_color_light' => 'Textfarbe (Hellmodus)',
        'text_color_light_help' => 'Standard-Text- und Icon-Farbe im Hellmodus',
        'text_color_dark' => 'Textfarbe (Dunkelmodus)',
        'text_color_dark_help' => 'Standard-Text- und Icon-Farbe im Dunkelmodus',
    ],

    // Icon Settings
    'icon' => [
        'app_icon' => 'App-Icon',
        'app_icon_description' => 'Laden Sie Ihr App-Icon als ZIP-Datei von icon.kitchen hoch',
        'current_icon' => 'Aktuelles Icon',
        'icon_zip_uploaded' => 'Icon-ZIP hochgeladen',
        'icon_zip_uploaded_description' => 'Extrahierte Icons sind für Android- und Web-Plattformen verfügbar',
        'default_icon' => 'Standard-Icon',
        'default_icon_description' => 'Laden Sie ein benutzerdefiniertes Icon hoch, um das Standard-Icon zu ersetzen',
        'delete' => 'Löschen',
        'upload_zip_file' => 'ZIP-Datei hochladen',
        'upload_zip_help' => 'ZIP-Datei von icon.kitchen (MAX. 10MB)',
        'how_to_create' => 'So erstellen Sie Ihr Icon:',
        'step_visit' => 'Besuchen Sie',
        'step_design' => 'Gestalten Sie Ihr App-Icon',
        'step_download' => 'Laden Sie die ZIP-Datei mit allen Plattform-Icons herunter',
        'step_upload' => 'Laden Sie die ZIP-Datei hier hoch',
        'zip_file_info' => 'Die ZIP-Datei sollte Icons für Android und Web enthalten (Max 10MB)',
        'upload_icon' => 'Icon hochladen',
    ],

    // Splashscreen Settings
    'splashscreen' => [
        'appearance' => 'Splashscreen-Erscheinung',
        'appearance_description' => 'Hintergrund, Anzeigedauer und Animationseffekte anpassen',
        'background_type' => 'Hintergrundtyp',
        'background_type_color' => 'Einfarbig',
        'background_type_image' => 'Hintergrundbild',
        'background_color' => 'Hintergrundfarbe',
        'background_image' => 'Hintergrundbild',
        'background_image_help' => 'Nur PNG (MAX. 2MB)',
        'delete_background_image' => 'Hintergrundbild löschen',
        'display_duration' => 'Anzeigedauer:',
        'seconds' => 'Sekunden',
        'animation_effect' => 'Animationseffekt',
        'animation_fade' => 'Einblenden',
        'animation_slide' => 'Gleiten',
        'animation_zoom' => 'Zoom',
        'animation_none' => 'Keine',
        'branding' => 'Splashscreen-Branding',
        'branding_description' => 'Logo, Titel, Untertitel und Textstil zu Ihrem Splashscreen hinzufügen',
        'show_logo' => 'Logo auf Splashscreen anzeigen',
        'logo_image' => 'Logo-Bild',
        'logo_image_help' => 'PNG mit Transparenz empfohlen (MAX. 2MB)',
        'delete_logo' => 'Logo löschen',
        'logo_size' => 'Logo-Größe:',
        'logo_size_small' => 'Klein (60dp)',
        'logo_size_medium' => 'Mittel (150dp)',
        'logo_size_large' => 'Groß (240dp)',
        'logo_size_help' => 'Logo-Größe für optimale Darstellung anpassen',
        'title' => 'Titel',
        'title_placeholder' => 'Meine tolle App',
        'subtitle' => 'Untertitel',
        'subtitle_placeholder' => 'Willkommen zur besten App überhaupt',
        'text_theme' => 'Text-Theme',
        'text_theme_light' => 'Hell (Weißer Text)',
        'text_theme_dark' => 'Dunkel (Schwarzer Text)',
    ],

    // Drawer Settings
    'drawer' => [
        'appearance' => 'Drawer-Erscheinung',
        'appearance_description' => 'Hintergrund und visuellen Stil Ihres Navigations-Drawers anpassen',
        'drawer_mode' => 'Drawer-Modus',
        'drawer_mode_help' => 'Wählen Sie, wie der Drawer-Hintergrund erscheinen soll',
        'mode_default' => 'Standard (Theme-Farbe)',
        'mode_color' => 'Benutzerdefinierte Farbe',
        'mode_image' => 'Hintergrundbild',
        'background_color' => 'Hintergrundfarbe',
        'background_color_help' => 'Benutzerdefinierte Hintergrundfarbe für den Drawer',
        'background_image' => 'Hintergrundbild',
        'background_image_help' => 'Nur PNG (MAX. 2MB). Empfohlen: 1080x1920px',
        'delete_background_image' => 'Hintergrundbild löschen',
        'branding' => 'Drawer-Branding',
        'branding_description' => 'Logo, Titel hinzufügen und Textdarstellung im Drawer-Header anpassen',
        'show_logo' => 'Logo im Drawer anzeigen',
        'show_logo_help' => 'Ein Logo im Drawer-Header anzeigen',
        'logo_light' => 'Drawer-Logo (Hellmodus)',
        'logo_light_help' => 'PNG mit Transparenz erforderlich (MAX. 2MB) - Wird bei hellem App-Theme angezeigt',
        'delete_light_logo' => 'Helles Logo löschen',
        'logo_dark' => 'Drawer-Logo (Dunkelmodus)',
        'logo_dark_help' => 'PNG mit Transparenz erforderlich (MAX. 2MB) - Wird bei dunklem App-Theme angezeigt',
        'delete_dark_logo' => 'Dunkles Logo löschen',
        'logo_size' => 'Logo-Größe:',
        'logo_size_small' => 'Klein (40dp)',
        'logo_size_medium' => 'Mittel (120dp)',
        'logo_size_large' => 'Groß (200dp)',
        'logo_size_help' => 'Logo-Größe für optimale Darstellung anpassen',
        'drawer_title' => 'Drawer-Titel',
        'drawer_title_placeholder' => 'Meine App',
        'drawer_title_help' => 'Titel, der im Drawer-Header angezeigt wird',
        'drawer_subtitle' => 'Drawer-Untertitel',
        'drawer_subtitle_placeholder' => 'Willkommen in meiner App',
        'drawer_subtitle_help' => 'Untertitel oder Slogan unter dem Titel',
        'text_theme' => 'Text-Theme',
        'text_theme_help' => 'Textfarbe für Drawer-Header und Menüelemente',
        'text_theme_light' => 'Hell (Weißer Text)',
        'text_theme_dark' => 'Dunkel (Schwarzer Text)',
        'item_colors' => 'Drawer-Element-Farben',
        'item_colors_description' => 'Icon- und Textfarben für Drawer-Menüelemente anpassen',
        'item_icon_colors' => 'Drawer-Element Icon-Farben',
        'item_icon_colors_help' => 'Farbe der inaktiven Drawer-Element-Icons und -Texte im Hell- und Dunkelmodus',
        'active_item_colors' => 'Aktive Element-Farben',
        'active_item_colors_help' => 'Farbe des ausgewählten/aktiven Drawer-Elements im Hell- und Dunkelmodus',
        'light_mode' => 'Hellmodus',
        'dark_mode' => 'Dunkelmodus',
    ],

    // Navigation Settings
    'navigation' => [
        'bottom_nav_bar' => 'Untere Navigationsleiste',
        'bottom_nav_bar_description' => 'Untere Navigations-Tab-Elemente konfigurieren (max. 8 Elemente)',
        'add_item' => '+ Element hinzufügen',
        'no_navigation_items' => 'Keine Navigationselemente konfiguriert',
        'add_first_navigation_item' => 'Fügen Sie Ihr erstes Navigationselement hinzu',
        'home_tab_badge' => 'Home-Tab - Mit Haupt-URL synchronisiert',
        'home_item_badge' => 'Home-Element - Mit Haupt-URL synchronisiert',
        'label' => 'Bezeichnung',
        'label_placeholder_home' => 'Startseite',
        'label_placeholder_about' => 'Über uns',
        'action_type' => 'Aktionstyp',
        'action_internal' => 'Interner Link',
        'action_external' => 'Externer Link',
        'action_hosted_page' => 'Gehostete Seite',
        'action_share' => 'Teilen',
        'action_email' => 'E-Mail senden',
        'action_call' => 'Anrufen',
        'url' => 'URL',
        'email_address' => 'E-Mail-Adresse',
        'phone_number' => 'Telefonnummer',
        'hosted_page' => 'Gehostete Seite',
        'select_page' => 'Seite auswählen',
        'synced_from_general' => 'Automatisch aus den Allgemeinen Einstellungen synchronisiert',
        'icon' => 'Icon',
        'select_icon' => 'Icon auswählen',
        'search_icons' => 'Icons suchen...',
        'home_tab_cannot_delete' => 'Home-Tab kann nicht gelöscht werden',
        'home_item_cannot_delete' => 'Home-Element kann nicht gelöscht werden',
        'max_navigation_items' => 'Maximum von 8 Navigationselementen erreicht (ohne Home-Tab)',
        'app_bar_buttons' => 'App-Bar Schaltflächen',
        'app_bar_buttons_description' => 'Aktionsschaltflächen oben rechts in der App-Bar hinzufügen (max. 3 Schaltflächen)',
        'add_button' => '+ Schaltfläche hinzufügen',
        'no_app_bar_buttons' => 'Keine App-Bar Schaltflächen konfiguriert',
        'add_first_app_bar_button' => 'Fügen Sie Ihre erste App-Bar Schaltfläche hinzu',
        'max_app_bar_buttons' => 'Maximum von 3 App-Bar Schaltflächen erreicht',
        'drawer_menu_items' => 'Drawer-Menüelemente',
        'drawer_menu_items_description' => 'Drawer-Menüelemente konfigurieren (1 Home + bis zu 9 weitere Elemente)',
        'no_drawer_items' => 'Keine Drawer-Menüelemente konfiguriert',
        'add_first_drawer_item' => 'Fügen Sie Ihr erstes Drawer-Menüelement hinzu',
        'max_drawer_items' => 'Maximum von 9 zusätzlichen Elementen erreicht (10 insgesamt inkl. Home-Element)',
        'behavior_settings' => 'Verhaltenseinstellungen',
        'behavior_settings_description' => 'Benutzerinteraktionen konfigurieren',
        'pull_to_refresh' => 'Ziehen zum Aktualisieren',
        'pull_to_refresh_description' => 'Benutzern erlauben, Inhalte durch Herunterziehen zu aktualisieren',
        'swipe_navigation' => 'Wisch-Navigation',
        'swipe_navigation_description' => 'Benutzern erlauben, durch Wischen vom Rand zurück zu navigieren',
        'swipe_navigation_disabled' => 'Für Drawer-Layouts deaktiviert, um Gestenkonflikte zu vermeiden',
        'preserve_tab_state' => 'Tab-Status beibehalten',
        'preserve_tab_state_description' => 'Aktuelle Seite beim Wechseln zwischen Tabs/Drawer-Elementen beibehalten',
    ],

    // Sidebar
    'sidebar' => [
        'app_settings' => 'App-Einstellungen',
        'general' => 'Allgemein',
        'design' => 'Design',
        'icon' => 'Icon',
        'splashscreen' => 'Splashscreen',
        'navigation' => 'Navigation',
        'drawer' => 'Drawer',
        'webview' => 'WebView',
        'permissions' => 'Berechtigungen',
        'custom_code' => 'Benutzerdefinierter Code',
        'hosted_pages' => 'Gehostete Seiten',
        'notifications' => 'Benachrichtigungen',
        'deployment' => 'Deployment',
        'builds' => 'Builds',
        'signing' => 'Signierung',
        'back_to_apps' => 'Zurück zu Apps',
    ],

    // WebView Settings
    'webview_user_agent_title' => 'User Agent',
    'webview_user_agent_description' => 'Den Browser User Agent String anpassen',
    'webview_custom_user_agent' => 'Benutzerdefinierter User Agent',
    'webview_user_agent_placeholder' => 'Leer lassen, um den Standard Android WebView User Agent zu verwenden',
    'webview_user_agent_helper' => 'Optional. Überschreibt den Standard User Agent, der an Ihre Website gesendet wird.',
    'webview_features_title' => 'WebView-Funktionen',
    'webview_features_description' => 'Browser-Fähigkeiten und -Verhalten konfigurieren',
    'webview_enable_javascript' => 'JavaScript aktivieren',
    'webview_enable_javascript_description' => 'JavaScript-Ausführung im WebView erlauben',
    'webview_enable_dom_storage' => 'DOM Storage aktivieren',
    'webview_enable_dom_storage_description' => 'localStorage und sessionStorage APIs erlauben',
    'webview_enable_zoom_controls' => 'Zoom-Steuerung aktivieren',
    'webview_enable_zoom_controls_description' => 'Pinch-to-Zoom und Zoom-Steuerungen erlauben',
    'webview_enable_cache' => 'Cache aktivieren',
    'webview_enable_cache_description' => 'Webinhalte für schnelleres Laden zwischenspeichern',

    // Permissions Settings
    'permissions_location_title' => 'Standortberechtigung',
    'permissions_location_description' => 'Zugriff auf Geräte-GPS für standortbasierte Funktionen',
    'permissions_enable_location' => 'Standortzugriff aktivieren',
    'permissions_location_helper' => 'Erforderlich für Karten, standortbasierte Inhalte und Geofencing-Funktionen.',
    'permissions_show_code_example' => 'Code-Beispiel anzeigen',
    'permissions_hide_code_example' => 'Code-Beispiel ausblenden',
    'permissions_javascript_example' => 'JavaScript-Beispiel:',
    'permissions_camera_title' => 'Kameraberechtigung',
    'permissions_camera_description' => 'Zugriff auf Gerätekamera für Fotos und Videos',
    'permissions_enable_camera' => 'Kamerazugriff aktivieren',
    'permissions_camera_helper' => 'Erforderlich für Fotos, QR-Code-Scannen und Videoanrufe.',
    'permissions_storage_title' => 'Speicherberechtigung',
    'permissions_storage_description' => 'Zugriff auf Gerätespeicher für Datei-Uploads und -Downloads',
    'permissions_enable_storage' => 'Speicherzugriff aktivieren',
    'permissions_storage_helper' => 'Erforderlich für Datei-Uploads, Bildauswahl und Datei-Downloads.',
    'permissions_microphone_title' => 'Mikrofonberechtigung',
    'permissions_microphone_description' => 'Zugriff auf Gerätemikrofon für Audioaufnahmen',
    'permissions_enable_microphone' => 'Mikrofonzugriff aktivieren',
    'permissions_microphone_helper' => 'Erforderlich für Sprachaufnahmen, Audioanrufe und Spracherkennung.',
    'permissions_contacts_title' => 'Kontakteberechtigung',
    'permissions_contacts_description' => 'Zugriff auf Gerätekontakte für soziale Funktionen',
    'permissions_enable_contacts' => 'Kontaktezugriff aktivieren',
    'permissions_contacts_helper' => 'Erforderlich für Kontaktauswahl, Einladungsfunktionen und soziale Integrationen.',
    'permissions_vibrate_title' => 'Vibrationsberechtigung',
    'permissions_vibrate_description' => 'Zugriff auf Gerätevibrationsmotor für haptisches Feedback',
    'permissions_enable_vibrate' => 'Vibration aktivieren',
    'permissions_vibrate_helper' => 'Erforderlich für haptisches Feedback und Benachrichtigungsvibrationen.',

    // Custom Code Settings
    'custom_code_access_required_title' => 'Upgrade erforderlich',
    'custom_code_access_required_description' => 'Ihr aktueller Tarif enthält keine benutzerdefinierte Code-Injektion. Upgraden Sie, um auf diese Funktion zuzugreifen und benutzerdefinierten CSS und JavaScript zu Ihrer App hinzuzufügen.',
    'custom_code_upgrade_plan' => 'Upgraden Sie Ihren Tarif',
    'custom_code_enable_feature' => 'um diese Funktion zu aktivieren.',
    'custom_code_css_title' => 'Benutzerdefiniertes CSS',
    'custom_code_css_description' => 'Benutzerdefinierte Stile hinzufügen, um das App-Erscheinungsbild zu personalisieren',
    'custom_code_css_label' => 'CSS-Code',
    'custom_code_css_helper' => 'Maximal 100KB. CSS wird in jede Seite eingefügt.',
    'custom_code_js_title' => 'Benutzerdefiniertes JavaScript',
    'custom_code_js_description' => 'Benutzerdefinierte Skripte für erweiterte Funktionalität hinzufügen',
    'custom_code_js_label' => 'JavaScript-Code',
    'custom_code_js_helper' => 'Maximal 100KB. JavaScript wird im WebView ausgeführt.',

    // Notifications Settings
    'notifications_title' => 'Benachrichtigungen',
    'notifications_description' => 'Firebase Cloud Messaging (FCM) für Benachrichtigungen konfigurieren',
    'notifications_enable' => 'Benachrichtigungen aktivieren',
    'notifications_firebase_service_account' => 'Firebase Service Account',
    'notifications_firebase_service_account_description' => 'Wird vom Server verwendet, um Benachrichtigungen über FCM API zu senden',
    'notifications_firebase_help_text' => 'JSON-Datei (MAX. 2MB)',
    'notifications_delete_firebase_credentials' => 'Firebase-Anmeldedaten löschen',
    'notifications_delete_firebase_credentials_confirm' => 'Sind Sie sicher, dass Sie die Firebase-Anmeldedaten-Datei löschen möchten?',
    'notifications_google_services' => 'Google Services',
    'notifications_google_services_description' => 'Erforderlich für Android-App-Konfiguration',
    'notifications_google_services_help_text' => 'JSON-Datei (MAX. 1MB)',
    'notifications_delete_google_services' => 'Google Services Datei löschen',
    'notifications_delete_google_services_confirm' => 'Sind Sie sicher, dass Sie die Google Services Datei löschen möchten?',

    // Signing Keys Settings
    'signing_keys' => [
        'android_keystores' => 'Android Keystores',
        'generate_new' => 'Neu generieren',
        'upload_existing' => 'Vorhandenen hochladen',
        'default_badge' => 'Standard',
        'alias' => 'Alias',
        'alias_placeholder' => 'mein-key-alias',
        'auto_generated' => 'Automatisch generiert',
        'created' => 'Erstellt',
        'set_as_default' => 'Als Standard festlegen',
        'edit' => 'Bearbeiten',
        'delete' => 'Löschen',
        'no_keystores' => 'Noch keine Android Keystores. Generieren Sie einen neuen Schlüssel oder laden Sie einen vorhandenen hoch.',
        'upload_signing_key' => 'Signierungsschlüssel hochladen',
        'android_keystore_upload' => 'Android Keystore Upload',
        'keystore_name' => 'Keystore-Name',
        'keystore_name_placeholder' => 'Mein Release Keystore',
        'keystore_file' => 'Keystore-Datei',
        'keystore_file_help' => '.jks, .keystore oder .ks Datei (Max 5MB)',
        'upload_custom_key' => 'Benutzerdefinierten Schlüssel hochladen',
        'upload_custom_key_help' => 'Deaktivieren Sie dies bei Verwendung eines automatisch generierten Debug-Keystores',
        'password' => 'Passwort',
        'password_placeholder' => '••••••••',
        'password_help' => 'Wird für Keystore- und Schlüsselzugriff verwendet',
        'cancel' => 'Abbrechen',
        'upload' => 'Hochladen',
        'edit_keystore' => 'Keystore bearbeiten',
        'update_password' => 'Passwort aktualisieren',
        'save' => 'Speichern',
        'delete_keystore' => 'Keystore löschen',
        'delete_confirmation' => 'Sind Sie sicher, dass Sie löschen möchten',
        'action_cannot_be_undone' => 'Diese Aktion kann nicht rückgängig gemacht werden.',

        // Keystore Generator Modal
        'generate_signing_key' => 'Signierungsschlüssel generieren',
        'generate_android_keystore' => 'Android Keystore generieren',
        'generate_keystore_description' => 'Ein neuer JKS-Keystore wird sicher auf dem Build-Server generiert',
        'keystore_name_generate_placeholder' => 'Mein App Release Key',
        'key_alias' => 'Schlüssel-Alias',
        'key_alias_placeholder' => 'mein-app-key',
        'key_alias_help' => 'Muss mit einem Buchstaben beginnen. Buchstaben, Zahlen, Bindestriche und Unterstriche erlaubt.',
        'password_settings' => 'Passwort-Einstellungen',
        'keystore_password' => 'Keystore-Passwort',
        'min_characters_placeholder' => 'Min. 6 Zeichen',
        'use_same_password' => 'Gleiches Passwort für Schlüssel und Keystore verwenden',
        'key_password' => 'Schlüssel-Passwort',
        'validity_period' => 'Gültigkeitszeitraum',
        'years_10' => '10 Jahre',
        'years_15' => '15 Jahre',
        'years_20' => '20 Jahre',
        'years_25_recommended' => '25 Jahre (Empfohlen)',
        'years_30' => '30 Jahre',
        'validity_help' => 'Google Play erfordert mindestens 25 Jahre Gültigkeit für neue Apps',
        'certificate_details' => 'Zertifikatsdetails (Optional)',
        'common_name' => 'Common Name (CN)',
        'common_name_placeholder' => 'Ihr App- oder Organisationsname',
        'organization' => 'Organisation (O)',
        'organization_placeholder' => 'Firmenname',
        'organizational_unit' => 'Organisationseinheit (OU)',
        'organizational_unit_placeholder' => 'Mobile Apps',
        'city' => 'Stadt (L)',
        'city_placeholder' => 'München',
        'state' => 'Bundesland (ST)',
        'state_placeholder' => 'Bayern',
        'country' => 'Land (C)',
        'country_placeholder' => 'DE',
        'save_password_warning' => 'Wichtig: Speichern Sie Ihr Passwort sicher!',
        'save_password_description' => 'Der Keystore wird verschlüsselt und gespeichert. Sie benötigen das Passwort für zukünftige Builds. Es gibt keine Möglichkeit, ein verlorenes Passwort wiederherzustellen.',
        'generating' => 'Wird generiert...',
        'generate_keystore' => 'Keystore generieren',
    ],

    // Hosted Pages Settings
    'hosted_pages' => [
        'access_required' => 'Zugang zu gehosteten Seiten erforderlich',
        'upgrade_description' => 'Ihr aktueller Tarif enthält keine gehosteten Seiten. Upgraden Sie Ihren Tarif, um benutzerdefinierte Seiten zu erstellen, die von uns gehostet werden.',
        'upgrade_plan' => 'Upgraden Sie Ihren Tarif',
        'upgrade_suffix' => 'um diese Funktion zu aktivieren.',
        'table_page' => 'Seite',
        'table_status' => 'Status',
        'table_created' => 'Erstellt',
        'table_actions' => 'Aktionen',
        'status_published' => 'Veröffentlicht',
        'status_draft' => 'Entwurf',
        'edit' => 'Bearbeiten',
        'delete' => 'Löschen',
        'no_pages' => 'Noch keine Seiten',
        'no_pages_description' => 'Klicken Sie auf "Seite hinzufügen", um Ihre erste gehostete Seite zu erstellen.',
    ],

    // Hosted Page Editor Modal
    'hosted_page_editor' => [
        'create_page' => 'Seite erstellen',
        'edit_page' => 'Seite bearbeiten',
        'title' => 'Titel',
        'title_placeholder' => 'Seitentitel',
        'slug' => 'Slug',
        'slug_placeholder' => 'seiten-slug',
        'start_from_template' => 'Von Vorlage starten',
        'status' => 'Status',
        'status_help' => 'Nur veröffentlichte Seiten sind in der App zugänglich',
        'cancel' => 'Abbrechen',
        'save_changes' => 'Änderungen speichern',
    ],

    // WordPress-specific Settings
    'wordpress' => [
        // General Settings
        'app_name_placeholder' => 'Meine WordPress App',
        'wordpress_site_url' => 'WordPress Website-URL',
        'wordpress_site_url_placeholder' => 'https://meinblog.wordpress.com',
        'wordpress_site_url_help' => 'Geben Sie Ihre WordPress.com Website-URL ein (z.B. meinblog.wordpress.com)',
        'app_id_placeholder' => 'com.beispiel.wordpress',
        'package_name_help' => 'Eindeutiger Bezeichner im Reverse-Domain-Format (z.B. com.firma.wordpress). Kann nach der Erstellung nicht geändert werden.',

        // Design Settings
        'post_list_style' => 'Beitragslisten-Stil',
        'style_list' => 'Liste',
        'style_grid' => 'Raster',
        'style_magazine' => 'Magazin',
        'post_list_style_help' => 'Wie Beiträge in der App angezeigt werden',
        'progress_indicator_help' => 'Stil des Ladeindikators beim Abrufen von Beiträgen',
        'show_app_bar_title' => 'App-Name in der App-Bar anzeigen',
        'show_app_bar_title_help' => 'Den Namen Ihrer App in der oberen Leiste anzeigen',
        'nav_tab_icon_colors_help' => 'Farbe der inaktiven Tab-Icons',
        'active_tab_colors_help' => 'Farbe des ausgewählten Tabs',
        'theme_color_help' => 'Hauptfarbe in Ihrer App (WordPress blau: #21759B)',
        'dynamic_colors_help' => 'Bei Aktivierung passt Ihre App die Farben an das Hintergrundbild des Benutzers auf Android 12+ Geräten an.',
        'layout_list_only' => 'Nur Liste',

        // Splashscreen Settings
        'splashscreen_title_placeholder' => 'Meine WordPress App',
        'splashscreen_subtitle_placeholder' => 'Willkommen zur besten Blog-App überhaupt',

        // Sidebar
        'content' => 'Inhalt',
        'features' => 'Funktionen',

        // Drawer Settings
        'drawer_appearance_description' => 'Den Navigations-Drawer-Hintergrund anpassen',
        'drawer_branding_description' => 'Logo, Titel und Textstil',
        'logo_light_mode' => 'Logo (Hellmodus)',
        'logo_dark_mode' => 'Logo (Dunkelmodus)',
        'png_transparency_help' => 'PNG mit Transparenz (MAX. 2MB)',
        'delete_background' => 'Hintergrund löschen',
        'drawer_title_placeholder' => 'Meine WordPress App',
        'drawer_subtitle_placeholder' => 'Ihr Slogan hier',
        'item_colors_description' => 'Icon- und Textfarben für Menüelemente',
        'inactive_item_colors' => 'Inaktive Element-Farben',

        // Navigation Settings
        'bottom_nav_tabs' => 'Untere Navigations-Tabs',
        'bottom_nav_tabs_description' => 'Untere Navigationselemente konfigurieren (max. 8 + Home)',
        'add_tab' => '+ Tab hinzufügen',
        'home_tab_shows_all_posts' => 'Home-Tab - Zeigt alle Beiträge',
        'home_item_shows_all_posts' => 'Home-Element - Zeigt alle Beiträge',
        'tab_name_placeholder' => 'Tab-Name',
        'menu_item_placeholder' => 'Menüelement',
        'action_category' => 'Kategorie',
        'action_tag' => 'Schlagwort',
        'action_search' => 'Suche',
        'action_bookmarks' => 'Lesezeichen',
        'action_share' => 'Teilen',
        'category_slug' => 'Kategorie-Slug',
        'tag_slug' => 'Schlagwort-Slug',
        'category_slug_placeholder' => 'technologie',
        'tag_slug_placeholder' => 'hervorgehoben',
        'app_bar_buttons_description' => 'Aktionsschaltflächen oben rechts (max. 3)',
        'no_app_bar_buttons_description' => 'Keine App-Bar Schaltflächen konfiguriert. Fügen Sie Suche, Teilen oder andere Schnellaktionen hinzu.',
        'search_placeholder' => 'Suchen',
        'drawer_menu_items_description' => 'Drawer-Menüelemente (1 Home + bis zu 9 Elemente)',
        'swipe_navigation_description' => 'Durch Wischen vom Rand zurück navigieren',
        'preserve_tab_state_description' => 'Scroll-Position beim Wechseln von Tabs beibehalten',

        // Content Settings
        'post_display' => 'Beitragsanzeige',
        'post_display_description' => 'Konfigurieren Sie, wie Beiträge in Ihrer App angezeigt werden',
        'posts_per_page' => 'Beiträge pro Seite',
        'posts_per_page_help' => 'Anzahl der gleichzeitig zu ladenden Beiträge (1-50)',
        'excerpt_length' => 'Auszugslänge (Zeichen)',
        'excerpt_length_help' => 'Maximale Zeichen in Beitragsauszügen (50-500)',
        'post_metadata' => 'Beitrags-Metadaten',
        'post_metadata_description' => 'Wählen Sie, welche Informationen bei jedem Beitrag angezeigt werden',
        'show_featured_image' => 'Beitragsbild anzeigen',
        'show_featured_image_help' => 'Das Beitragsbild/Thumbnail anzeigen',
        'show_excerpt' => 'Beitragsauszug anzeigen',
        'show_excerpt_help' => 'Eine Vorschau des Beitragsinhalts anzeigen',
        'show_author' => 'Autorname anzeigen',
        'show_author_help' => 'Den Autor anzeigen, der den Beitrag geschrieben hat',
        'show_date' => 'Veröffentlichungsdatum anzeigen',
        'show_date_help' => 'Anzeigen, wann der Beitrag veröffentlicht wurde',
        'show_categories' => 'Kategorien anzeigen',
        'show_categories_help' => 'Die dem Beitrag zugewiesenen Kategorien anzeigen',
        'show_reading_time' => 'Geschätzte Lesezeit anzeigen',
        'show_reading_time_help' => 'Anzeigen, wie lange es dauert, den Beitrag zu lesen',

        // Features Settings
        'core_features' => 'Kernfunktionen',
        'core_features_description' => 'App-Funktionalität aktivieren oder deaktivieren',
        'enable_search' => 'Suche aktivieren',
        'enable_search_help' => 'Benutzern erlauben, in Ihrer App nach Beiträgen zu suchen',
        'enable_comments' => 'Kommentare aktivieren',
        'enable_comments_help' => 'Benutzern erlauben, Kommentare zu Artikeln anzuzeigen und zu posten',
        'enable_bookmarks' => 'Lesezeichen aktivieren',
        'enable_bookmarks_help' => 'Benutzern erlauben, Beiträge für später zu speichern',
        'enable_share' => 'Teilen aktivieren',
        'enable_share_help' => 'Benutzern erlauben, Beiträge über andere Apps zu teilen',
        'advanced_features' => 'Erweiterte Funktionen',
        'advanced_features_description' => 'Zusätzliche Funktionalität für verbesserte Benutzererfahrung',
        'enable_offline_reading' => 'Offline-Lesen aktivieren',
        'enable_offline_reading_help' => 'Beiträge zum Lesen ohne Internetverbindung zwischenspeichern',
        'enable_user_auth' => 'Benutzerauthentifizierung aktivieren',
        'enable_user_auth_help' => 'Benutzern erlauben, sich mit ihrem WordPress.com-Konto anzumelden',
        'enable_push_notifications' => 'Push-Benachrichtigungen aktivieren',
        'enable_push_notifications_help' => 'Benachrichtigungen senden, wenn neue Beiträge veröffentlicht werden',
    ],

    // Builds
    'builds' => [
        // Builds Table
        'search_placeholder' => 'Builds suchen...',
        'filter' => 'Filtern',
        'platform_filter' => 'Plattform',
        'status_filter' => 'Status',
        'android' => 'Android',
        'completed' => 'Abgeschlossen',
        'building' => 'Wird erstellt',
        'failed' => 'Fehlgeschlagen',
        'pending' => 'Ausstehend',
        'table_platform' => 'Plattform',
        'table_build_info' => 'Build-Info',
        'table_created' => 'Erstellt',
        'table_actions' => 'Aktionen',
        'release' => 'Release',
        'debug' => 'Debug',
        'download' => 'Herunterladen',
        'preview' => 'Vorschau',
        'logs' => 'Protokolle',
        'delete' => 'Löschen',
        'no_builds' => 'Keine Builds gefunden',

        // Build Modal
        'create_new_build' => 'Neuen Build erstellen',
        'platform_label' => 'Plattform',
        'build_costs_credit' => 'Build kostet :count Credit|Build kostet :count Credits',
        'build_type_label' => 'Build-Typ',
        'for_testing' => 'Zum Testen',
        'for_production' => 'Für Produktion',
        'output_format_label' => 'Ausgabeformat',
        'apk' => 'APK',
        'aab' => 'AAB',
        'for_testing_sideloading' => 'Zum Testen/Sideloading',
        'for_google_play_store' => 'Für Google Play Store',
        'builder_label' => 'Builder',
        'auto_select_recommended' => 'Automatische Auswahl (empfohlen)',
        'auto_select_help' => 'Belassen Sie "Automatische Auswahl", um den am wenigsten ausgelasteten Builder zu verwenden, oder wählen Sie einen bestimmten Builder.',
        'no_builders_available' => 'Keine Builder verfügbar!',
        'no_builders_help' => 'Ihr Tarif hat keinen Zugang zu Buildern. Bitte kontaktieren Sie den Support oder upgraden Sie Ihren Tarif.',
        'signing_key_label' => 'Signierungsschlüssel',
        'select_keystore' => 'Keystore auswählen',
        'no_keystores_available' => 'Keine Keystores verfügbar.',
        'upload_in_signing_section' => 'Laden Sie einen im Signierung-Bereich hoch',
        'signing_key_required' => 'Signierungsschlüssel erforderlich!',
        'version_name_label' => 'Versionsname',
        'version_name_help' => 'Format: X.Y oder X.Y.Z (z.B. 1.0 oder 1.0.0). Wird für jede Plattform automatisch erhöht.',
        'build_number_label' => 'Build-Nummer',
        'next_build_number' => 'Nächste Build-Nummer',
        'build_number_auto_increment' => 'Build-Nummer wird bei jedem Build automatisch erhöht',
        'build_cost_info' => 'Dieser Build kostet :count Credit|Dieser Build kostet :count Credits',
        'build_email_notification' => 'Sie erhalten eine E-Mail, wenn der Build zum Download bereit ist.',
        'cancel' => 'Abbrechen',
        'start_build' => 'Build starten',
        'credit' => 'Credit',
        'credits' => 'Credits',
        'builder_info' => 'Builder:',

        // Build Logs Modal
        'build_logs' => 'Build-Protokolle',
        'duration' => 'Dauer:',
        'no_logs_available' => 'Keine Protokolle für diesen Build verfügbar',
        'error' => 'Fehler:',
        'close' => 'Schließen',
        'download_build' => 'Build herunterladen',

        // Build Download Modal
        'download_build_title' => 'Build herunterladen',
        'aab_title' => 'Android App Bundle (AAB)',
        'aab_description' => 'Dies ist eine AAB-Datei, die nicht direkt auf Geräten installiert werden kann. AAB-Dateien sind für den Upload zur Google Play Console gedacht, wo Google optimierte APKs für Benutzer generiert.',
        'scan_with_android' => 'Mit Ihrem Android-Gerät scannen',
        'qr_unavailable' => 'QR-Code nicht verfügbar',
        'download_options' => 'Download-Optionen',
        'download_options_description' => 'Scannen Sie den QR-Code mit Ihrem Mobilgerät oder verwenden Sie den direkten Download-Link unten.',
        'download_format' => ':format herunterladen',
        'installation_note' => 'Installation:',
        'installation_help' => 'Möglicherweise müssen Sie "Installation aus unbekannten Quellen" in Ihren Android-Einstellungen aktivieren.',
        'download_aab_file' => 'AAB-Datei herunterladen',
        'upload_to_play_console' => 'Laden Sie diese Datei in die Google Play Console hoch, um Ihre App zu veröffentlichen.',
        'next_steps' => 'Nächste Schritte:',
        'next_steps_help' => 'Laden Sie diese AAB-Datei in die Google Play Console unter Release > Produktion/Test hoch. Google generiert automatisch optimierte APKs für Ihre Benutzer.',

        // Delete Build Modal
        'delete_build' => 'Build löschen',
        'delete_confirmation' => 'Sind Sie sicher, dass Sie den',
        'build_suffix' => 'Build löschen möchten?',
        'action_cannot_be_undone' => 'Diese Aktion kann nicht rückgängig gemacht werden.',
    ],

    // App Preview Panel
    'preview' => [
        'no_build_selected' => 'Kein Build ausgewählt',
        'select_build_help' => 'Wählen Sie einen abgeschlossenen Build aus dem Builds-Tab, um ihn hier anzuzeigen',
    ],

    // App Creation Form
    'creation' => [
        'website_url' => 'Website-URL',
        'app_id' => 'APP-ID',
        'app_id_tooltip' => 'Eindeutiger Paketbezeichner (kann nach der Erstellung nicht geändert werden)',
        'auto_generate_package' => 'Aus App-Name automatisch generieren',
        'package_name_help' => 'Eindeutiger Bezeichner im Reverse-Domain-Format (z.B. com.firma.app). Kann nach der Erstellung nicht geändert werden.',
        'theme_color' => 'Theme-Farbe',
        'theme_color_help' => 'Hauptfarbe in Ihrer App. Textfarben verwenden Standard-Schwarz/Weiß und können später angepasst werden.',
        'layout_template' => 'Layout-Vorlage',
        'layout_app_bar_drawer' => 'App-Bar + Drawer',
        'layout_app_bar_tabs' => 'App-Bar + Navigations-Tabs',
        'layout_app_bar' => 'App-Bar',
        'layout_blank' => 'Leer',
        'layout_help' => 'Wählen Sie die Navigationsstruktur für Ihre App',
    ],

    // Delete Modals
    'modals' => [
        'cancel' => 'Abbrechen',
        'delete' => 'Löschen',
        'action_cannot_be_undone' => 'Diese Aktion kann nicht rückgängig gemacht werden.',
        'delete_build' => 'Build löschen',
        'delete_build_confirmation' => 'Sind Sie sicher, dass Sie den',
        'build_suffix' => 'Build löschen möchten?',
        'delete_app_icon' => 'App-Icon löschen',
        'delete_icon_confirmation' => 'Sind Sie sicher, dass Sie das Icon löschen möchten für',
        'delete_keystore' => 'Keystore löschen',
        'delete_keystore_confirmation' => 'Sind Sie sicher, dass Sie löschen möchten',
        'delete_splashscreen_background' => 'Splashscreen-Hintergrund löschen',
        'delete_splashscreen_background_confirmation' => 'Sind Sie sicher, dass Sie das Splashscreen-Hintergrundbild löschen möchten für',
        'delete_splashscreen_logo' => 'Splashscreen-Logo löschen',
        'delete_splashscreen_logo_confirmation' => 'Sind Sie sicher, dass Sie das Splashscreen-Logo löschen möchten für',
        'delete_drawer_background' => 'Drawer-Hintergrund löschen',
        'delete_drawer_background_confirmation' => 'Sind Sie sicher, dass Sie das Drawer-Hintergrundbild löschen möchten für',
        'delete_dark_mode_logo' => 'Dunkelmodus-Logo löschen',
        'delete_dark_mode_logo_confirmation' => 'Sind Sie sicher, dass Sie das Drawer-Dunkelmodus-Logo löschen möchten für',
        'delete_light_mode_logo' => 'Hellmodus-Logo löschen',
        'delete_light_mode_logo_confirmation' => 'Sind Sie sicher, dass Sie das Drawer-Hellmodus-Logo löschen möchten für',
        'delete_page' => 'Seite löschen',
        'delete_page_confirmation' => 'Sind Sie sicher, dass Sie löschen möchten',
        'delete_page_warning' => 'Diese Aktion kann nicht rückgängig gemacht werden. Wenn diese Seite in Ihrer Navigation verwendet wird, ist sie nicht mehr zugänglich.',
    ],

    // WordPress Notifications Settings
    'notifications_wp' => [
        'title' => 'Push-Benachrichtigungen',
        'description' => 'Firebase Cloud Messaging für Push-Benachrichtigungen konfigurieren',
        'enable_label' => 'Push-Benachrichtigungen aktivieren',
        'enable_help' => 'Benachrichtigungen senden, wenn neue Beiträge veröffentlicht werden',
        'firebase_required_title' => 'Firebase-Konfiguration erforderlich',
        'firebase_required_description' => 'Laden Sie beide Konfigurationsdateien unten hoch, um Push-Benachrichtigungen in Ihrer App zu aktivieren.',
        'google_services_label' => 'google-services.json',
        'file_uploaded' => 'Datei hochgeladen',
        'google_services_configured' => 'google-services.json ist konfiguriert',
        'delete' => 'Löschen',
        'delete_file_confirm' => 'Sind Sie sicher, dass Sie diese Datei löschen möchten?',
        'upload_google_services' => 'google-services.json hochladen',
        'google_services_help' => 'Von Firebase Console herunterladen (MAX. 1MB)',
        'google_services_instructions' => 'Von Firebase Console > Projekteinstellungen > Ihre Apps > Android-App herunterladen',
        'firebase_service_account_label' => 'Firebase Service Account (zum Senden von Benachrichtigungen)',
        'credentials_configured' => 'Anmeldedaten konfiguriert',
        'service_account_stored' => 'Service Account ist sicher gespeichert',
        'delete_credentials_confirm' => 'Sind Sie sicher, dass Sie diese Anmeldedaten löschen möchten?',
        'upload_service_account' => 'Service Account JSON hochladen',
        'service_account_help' => 'Von Firebase Console herunterladen (MAX. 2MB)',
        'service_account_instructions' => 'Von Firebase Console > Projekteinstellungen > Dienstkonten > Neuen privaten Schlüssel generieren herunterladen',
        'setup_title' => 'So richten Sie Firebase ein:',
        'setup_step_1' => 'Gehen Sie zu',
        'setup_step_2' => 'Erstellen Sie ein Projekt oder wählen Sie ein vorhandenes aus',
        'setup_step_3' => 'Fügen Sie eine Android-App mit Ihrem Paketnamen hinzu:',
        'setup_step_4' => 'Laden Sie herunter',
        'setup_step_4_suffix' => 'und laden Sie es oben hoch',
        'setup_step_5' => 'Gehen Sie zu Projekteinstellungen > Dienstkonten',
        'setup_step_6' => 'Generieren Sie einen neuen privaten Schlüssel und laden Sie ihn oben hoch',
    ],

    // Toast Messages - Settings
    'toast' => [
        // General success/error
        'settings_saved' => ':section-Einstellungen erfolgreich gespeichert!',
        'settings_save_failed' => 'Einstellungen konnten nicht gespeichert werden. Bitte versuchen Sie es erneut.',

        // Design settings
        'design_saved' => 'Design-Einstellungen erfolgreich gespeichert!',

        // Navigation settings
        'navigation_saved' => 'Navigationseinstellungen erfolgreich gespeichert!',
        'home_tab_cannot_delete' => 'Home-Tab kann nicht gelöscht werden. Er ist für die Navigation erforderlich.',
        'home_tab_cannot_move' => 'Home-Tab muss an erster Stelle bleiben und kann nicht verschoben werden.',
        'cannot_move_below_home' => 'Elemente können nicht unter den Home-Tab verschoben werden.',
        'home_item_cannot_delete' => 'Home-Element kann nicht gelöscht werden. Es ist für die Navigation erforderlich.',
        'home_item_cannot_move' => 'Home-Element muss an erster Stelle bleiben und kann nicht verschoben werden.',
        'cannot_move_below_home_item' => 'Elemente können nicht unter das Home-Element verschoben werden.',

        // Custom code
        'custom_code_saved' => 'Benutzerdefinierter Code erfolgreich gespeichert!',
        'custom_code_save_failed' => 'Benutzerdefinierter Code konnte nicht gespeichert werden. Bitte versuchen Sie es erneut.',
        'custom_code_no_access' => 'Ihr Tarif enthält keinen Zugang zu benutzerdefiniertem Code. Bitte aktualisieren Sie Ihren Tarif.',

        // WebView settings
        'webview_saved' => 'WebView-Einstellungen erfolgreich gespeichert!',

        // Permissions settings
        'permissions_saved' => 'Berechtigungen erfolgreich gespeichert!',

        // Drawer settings
        'drawer_saved' => 'Drawer-Einstellungen erfolgreich gespeichert!',

        // General settings
        'general_saved' => 'Allgemeine Einstellungen erfolgreich gespeichert!',

        // Splashscreen settings
        'splashscreen_saved' => 'Splashscreen-Einstellungen erfolgreich gespeichert!',

        // Icon settings
        'icon_uploaded' => 'App-Icon erfolgreich hochgeladen!',
        'icon_upload_failed' => 'Icon konnte nicht hochgeladen werden: :error',
        'icon_removed' => 'App-Icon erfolgreich entfernt!',
        'icon_remove_failed' => 'Icon konnte nicht entfernt werden. Bitte versuchen Sie es erneut.',

        // Splashscreen modals
        'splashscreen_background_deleted' => 'Splashscreen-Hintergrundbild erfolgreich gelöscht!',
        'splashscreen_background_delete_failed' => 'Hintergrundbild konnte nicht gelöscht werden. Bitte versuchen Sie es erneut.',
        'splashscreen_logo_deleted' => 'Splashscreen-Logo erfolgreich gelöscht!',
        'splashscreen_logo_delete_failed' => 'Logo konnte nicht gelöscht werden. Bitte versuchen Sie es erneut.',

        // Drawer modals
        'drawer_background_deleted' => 'Drawer-Hintergrundbild erfolgreich gelöscht!',
        'drawer_background_delete_failed' => 'Hintergrundbild konnte nicht gelöscht werden. Bitte versuchen Sie es erneut.',
        'drawer_logo_deleted' => 'Drawer-Logo erfolgreich gelöscht!',
        'drawer_logo_delete_failed' => 'Logo konnte nicht gelöscht werden. Bitte versuchen Sie es erneut.',
        'drawer_logo_light_deleted' => 'Helles Drawer-Logo erfolgreich gelöscht!',
        'drawer_logo_dark_deleted' => 'Dunkles Drawer-Logo erfolgreich gelöscht!',

        // Notifications settings
        'notifications_saved' => 'Benachrichtigungseinstellungen erfolgreich gespeichert!',
        'firebase_credentials_deleted' => 'Firebase-Anmeldedaten erfolgreich gelöscht!',
        'firebase_credentials_delete_failed' => 'Firebase-Anmeldedaten konnten nicht gelöscht werden. Bitte versuchen Sie es erneut.',
        'google_services_deleted' => 'Google Services-Datei erfolgreich gelöscht!',
        'google_services_delete_failed' => 'Google Services-Datei konnte nicht gelöscht werden. Bitte versuchen Sie es erneut.',

        // Signing keys
        'keystore_updated' => 'Keystore erfolgreich aktualisiert!',
        'keystore_update_failed' => 'Keystore konnte nicht aktualisiert werden.',
        'keystore_load_failed' => 'Keystore konnte nicht geladen werden.',
        'keystore_deleted' => 'Keystore erfolgreich gelöscht!',
        'keystore_delete_failed' => 'Keystore konnte nicht gelöscht werden. Bitte versuchen Sie es erneut.',
        'keystore_uploaded' => 'Keystore erfolgreich hochgeladen!',
        'keystore_upload_failed' => 'Signaturschlüssel konnte nicht hochgeladen werden: :error',
        'keystore_generated' => 'Keystore erfolgreich generiert!',
        'keystore_set_default' => 'Standard-Keystore erfolgreich aktualisiert!',

        // Build modal
        'build_no_builders_platform' => 'Keine Builder für die :platform-Plattform verfügbar. Bitte kontaktieren Sie den Support oder aktualisieren Sie Ihren Tarif.',
        'build_no_subscription' => 'Sie benötigen ein aktives Abonnement, um Apps zu erstellen. Bitte abonnieren Sie einen Tarif.',
        'build_no_builders_plan' => 'Keine Builder für Ihren Tarif verfügbar. Bitte kontaktieren Sie den Support oder aktualisieren Sie Ihren Tarif.',
        'build_builder_not_available' => 'Der ausgewählte Builder ist für Ihren Tarif nicht verfügbar.',
        'build_builder_unavailable' => 'Der ausgewählte Builder ist derzeit nicht verfügbar.',
        'build_builder_no_platform' => 'Der ausgewählte Builder unterstützt die :platform-Plattform nicht.',
        'build_insufficient_credits' => 'Unzureichende Build-Credits. Dieser Build erfordert :count Credit(s). Bitte aktualisieren Sie Ihren Tarif oder warten Sie auf die monatliche Zurücksetzung.',
        'build_keystore_required' => 'Android-Keystore ist für Release-Builds erforderlich. Bitte wählen Sie einen Keystore aus.',
        'build_keystore_invalid' => 'Ausgewählter Keystore ist ungültig.',
        'build_already_in_progress' => 'Ein :platform-Build ist bereits in Bearbeitung. Bitte warten Sie auf dessen Abschluss.',
        'build_queued' => ':platform-Build erfolgreich in die Warteschlange eingereiht! Ihr Build wird verarbeitet, sobald ein Builder verfügbar ist. (:credits Credits verbleibend)',
        'build_queued_on_builder' => ':platform-Build erfolgreich auf :builder in die Warteschlange eingereiht! (:credits Credits verbleibend)',
        'build_create_failed' => 'Build konnte nicht erstellt werden: :error',
        'build_deleted' => 'Build erfolgreich gelöscht!',
        'build_delete_failed' => 'Build konnte nicht gelöscht werden. Bitte versuchen Sie es erneut.',

        // Hosted pages
        'hosted_page_saved' => 'Seite erfolgreich gespeichert!',
        'hosted_page_save_failed' => 'Seite konnte nicht gespeichert werden. Bitte versuchen Sie es erneut.',
        'hosted_page_deleted' => 'Seite erfolgreich gelöscht!',
        'hosted_page_delete_failed' => 'Seite konnte nicht gelöscht werden. Bitte versuchen Sie es erneut.',
        'hosted_page_limit_reached' => 'Sie haben das Maximum an gehosteten Seiten für Ihren Tarif erreicht.',
        'hosted_page_no_access' => 'Ihr aktueller Tarif enthält keine gehosteten Seiten. Aktualisieren Sie Ihren Tarif, um benutzerdefinierte Seiten zu erstellen.',

        // Additional toast keys for AndroidWordPress
        'features_saved' => 'Feature-Einstellungen erfolgreich gespeichert!',
        'content_saved' => 'Inhaltseinstellungen erfolgreich gespeichert!',
        'storage_link_missing' => 'Storage-Link nicht gefunden. Führen Sie aus: php artisan storage:link',
        'splashscreen_image_deleted' => 'Splashscreen-Hintergrundbild erfolgreich gelöscht!',
        'splashscreen_image_delete_failed' => 'Hintergrundbild konnte nicht gelöscht werden. Bitte versuchen Sie es erneut.',
        'logo_delete_failed' => 'Logo konnte nicht gelöscht werden. Bitte versuchen Sie es erneut.',
        'default_key_updated' => 'Standard-Signierungsschlüssel erfolgreich aktualisiert!',
        'default_key_update_failed' => 'Standard-Signierungsschlüssel konnte nicht aktualisiert werden.',
        'keystore_uploaded_default' => 'Keystore hochgeladen und als Standard festgelegt!',
        'signing_key_upload_failed' => 'Signierungsschlüssel konnte nicht hochgeladen werden: :error',
        'page_not_found' => 'Seite nicht gefunden.',
        'page_deleted' => 'Seite erfolgreich gelöscht!',
        'page_delete_failed' => 'Seite konnte nicht gelöscht werden. Bitte versuchen Sie es erneut.',
        'page_updated' => 'Seite erfolgreich aktualisiert!',
        'page_created' => 'Seite erfolgreich erstellt!',
        'page_save_failed' => 'Seite konnte nicht gespeichert werden. Bitte versuchen Sie es erneut.',
        'page_limit_reached' => 'Sie haben das Maximum von :max Seiten für Ihren Tarif erreicht.',
        'hosted_pages_not_available' => 'Ihr Tarif enthält keine gehosteten Seiten. Bitte aktualisieren Sie Ihren Tarif.',
        'unauthorized' => 'Nicht autorisierte Aktion.',
        'home_tab_required' => 'Home-Tab kann nicht gelöscht werden. Er ist für die Navigation erforderlich.',
        'home_tab_first' => 'Home-Tab muss an erster Stelle bleiben.',
        'home_item_required' => 'Home-Element kann nicht gelöscht werden.',
        'build_no_builders' => 'Keine Builder für die :platform-Plattform verfügbar. Bitte kontaktieren Sie den Support oder aktualisieren Sie Ihren Tarif.',
        'build_no_plan_builders' => 'Keine Builder für Ihren Tarif verfügbar. Bitte kontaktieren Sie den Support oder aktualisieren Sie Ihren Tarif.',
        'build_builder_platform_unsupported' => 'Der ausgewählte Builder unterstützt die :platform-Plattform nicht.',
        'build_insufficient_credits' => 'Unzureichende Build-Credits. Dieser Build erfordert :credits Credit(s). Bitte aktualisieren Sie Ihren Tarif oder warten Sie auf die monatliche Zurücksetzung.',
        'build_invalid_keystore' => 'Ausgewählter Keystore ist ungültig.',
        'build_queued_no_builder' => ':platform-Build erfolgreich in die Warteschlange eingereiht! Ihr Build wird verarbeitet, sobald ein Builder verfügbar ist. (:credits Credits verbleibend)',
        'build_queued_success' => ':platform-Build erfolgreich auf :builder in die Warteschlange eingereiht! (:credits Credits verbleibend)',
        'available_builder' => 'verfügbarer Builder',
        'invalid_google_services_json' => 'Ungültige JSON-Datei. Bitte laden Sie eine gültige google-services.json hoch.',
        'invalid_google_services_structure' => 'Ungültige google-services.json. Erforderlicher project_info oder client Abschnitt fehlt.',
        'invalid_firebase_service_account' => 'Ungültige JSON-Datei. Bitte laden Sie eine gültige Firebase-Dienstkonto-Datei hoch.',
        'invalid_firebase_service_account_type' => 'Ungültige Firebase-Dienstkonto-Datei. Typ-Feld fehlt oder ist ungültig.',
        'settings_save_failed_error' => 'Einstellungen konnten nicht gespeichert werden: :error',
        'file_delete_failed' => 'Datei konnte nicht gelöscht werden: :error',
        'credentials_delete_failed' => 'Anmeldedaten konnten nicht gelöscht werden: :error',
    ],

    // Editor Section Headers
    'sections' => [
        'general' => 'Allgemein',
        'general_description' => 'Grundinformationen und Konfigurationseinstellungen',
        'design' => 'Design',
        'design_description' => 'Layout, Farben und Theme-Einstellungen anpassen',
        'icon' => 'Icon',
        'icon_description' => 'App-Icon für Android hochladen',
        'splashscreen' => 'Splashscreen',
        'splashscreen_description' => 'Startbildschirm-Erscheinung und Animation konfigurieren',
        'navigation' => 'Navigation',
        'navigation_description' => 'Navigationselemente und App-Bar Schaltflächen verwalten',
        'drawer' => 'Drawer-Einstellungen',
        'drawer_description' => 'Drawer-Menü-Erscheinung und Branding anpassen',
        'webview' => 'WebView-Einstellungen',
        'webview_description' => 'WebView-Verhalten und Funktionen konfigurieren',
        'permissions' => 'Berechtigungen',
        'permissions_description' => 'Geräteberechtigungen konfigurieren, die Ihre App anfordert',
        'custom_code' => 'Benutzerdefinierter Code',
        'custom_code_description' => 'Benutzerdefiniertes CSS und JavaScript in Ihre App einfügen',
        'hosted_pages' => 'Gehostete Seiten',
        'hosted_pages_description' => 'Benutzerdefinierte HTML-Seiten erstellen, die von uns für Ihre App gehostet werden',
        'pages' => 'Seiten',
        'add_page' => 'Seite hinzufügen',
        'notifications' => 'Benachrichtigungen',
        'notifications_description' => 'Firebase Cloud Messaging für Benachrichtigungen konfigurieren',
        'builds' => 'Builds',
        'builds_description' => 'Android APK- und AAB-Dateien für Deployment generieren',
        'credits' => 'Credits',
        'new_build' => 'Neuer Build',
        'signing' => 'Signierung',
        'signing_description' => 'Signierungsschlüssel für App-Verteilung verwalten',
        // WordPress-specific sections
        'general_description_wordpress' => 'Grundinformationen und WordPress-Website-Konfiguration',
        'content' => 'Inhalt',
        'content_description' => 'Beitragsanzeige und Inhaltseinstellungen konfigurieren',
        'features' => 'Funktionen',
        'features_description' => 'App-Funktionen aktivieren oder deaktivieren',
    ],

];
